package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.ProjectTaskBookDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目任务书
 * 
 * @author generator
 * 
 */
public class ProjectTaskBookVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long prjimplProtocolId; // 项目实施协议ID
    private Long projectId; // 项目id
    private String name; // 项目名称
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 组织ID
    private String pubUnitName; // 发包单位名称
    private String contractUnitName; // 承包单位名称
    private BigDecimal prjimplProtocolTotal; // 实施协议金额
    private BigDecimal prjtaskcostTotal; // 项目任务书金额
    private BigDecimal prjsaleCost; // 销售费用
    private BigDecimal workloadCost; // 工作量金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 项目完工时间
    private Integer totalPeriod; // 总工期
    private Long establishmentOrgId; // 编制单位ID
    private String establishmentOrgName; // 编制单位名称
    private Long establishmentUserId; // 编制人ID
    private String establishmentUserName; // 编制人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制日期
    private String produceContent; // 生产
    private String qualityContent; // 质量
    private String safeContent; // 安全
    private String costConent; // 成本
    private String otherContent; // 其他
    private String remark; // 备注
    
    private List<ProjectTaskBookDetailVO> projectTaskBookDetailList = new ArrayList<>(); // 项目任务书明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getPrjimplProtocolId() {
        return prjimplProtocolId;
    }

    public void setPrjimplProtocolId(Long prjimplProtocolId) {
        this.prjimplProtocolId = prjimplProtocolId;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public BigDecimal getPrjimplProtocolTotal() {
        return prjimplProtocolTotal;
    }

    public void setPrjimplProtocolTotal(BigDecimal prjimplProtocolTotal) {
        this.prjimplProtocolTotal = prjimplProtocolTotal;
    }
    public BigDecimal getPrjtaskcostTotal() {
        return prjtaskcostTotal;
    }

    public void setPrjtaskcostTotal(BigDecimal prjtaskcostTotal) {
        this.prjtaskcostTotal = prjtaskcostTotal;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTotalPeriod() {
        return totalPeriod;
    }

    public void setTotalPeriod(Integer totalPeriod) {
        this.totalPeriod = totalPeriod;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getProduceContent() {
        return produceContent;
    }

    public void setProduceContent(String produceContent) {
        this.produceContent = produceContent;
    }
    public String getQualityContent() {
        return qualityContent;
    }

    public void setQualityContent(String qualityContent) {
        this.qualityContent = qualityContent;
    }
    public String getSafeContent() {
        return safeContent;
    }

    public void setSafeContent(String safeContent) {
        this.safeContent = safeContent;
    }
    public String getCostConent() {
        return costConent;
    }

    public void setCostConent(String costConent) {
        this.costConent = costConent;
    }
    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getPrjsaleCost() {
        return prjsaleCost;
    }

    public void setPrjsaleCost(BigDecimal prjsaleCost) {
        this.prjsaleCost = prjsaleCost;
    }

    public BigDecimal getWorkloadCost() {
        return workloadCost;
    }

    public void setWorkloadCost(BigDecimal workloadCost) {
        this.workloadCost = workloadCost;
    }

    public List<ProjectTaskBookDetailVO> getProjectTaskBookDetailList() {
        return projectTaskBookDetailList;
     }

     public void setProjectTaskBookDetailList(List<ProjectTaskBookDetailVO> projectTaskBookDetailList) {
        this.projectTaskBookDetailList = projectTaskBookDetailList;
     }

    public String getName() {
        return projectName;
    }

}
