package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.ProjectTargetcostChangeMapper;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IProjectTargetcostChangeService;
import com.ejianc.business.cost.service.IProjectTargetcostRecordService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.EngdepartRespcostDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeDetailVO;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeVO;
import com.ejianc.business.cost.vo.ProjectTargetcostRecordVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目目标成本变更
 * 
 * @author generator
 * 
 */
@Service("projectTargetcostChangeService")
public class ProjectTargetcostChangeServiceImpl extends BaseServiceImpl<ProjectTargetcostChangeMapper, ProjectTargetcostChangeEntity> implements IProjectTargetcostChangeService{

    @Autowired
    private IProjectTargetcostService projectTargetcostService;
    @Autowired
    private IProjectTargetcostRecordService recordService;
    @Autowired
    private IEngdepartRespcostService engdepartRespcostService;
    @Autowired
    private ProjectUtils projectUtils;

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> saveChange(ProjectTargetcostChangeVO saveOrUpdateVO) {
        ProjectTargetcostChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTargetcostChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ProjectTargetcostChangeEntity> queryWrapper = new QueryWrapper<ProjectTargetcostChangeEntity>();
        queryWrapper.eq("taskcost_id", saveOrUpdateVO.getTaskcostId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ProjectTargetcostChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        BigDecimal contractMny = saveOrUpdateVO.getContractTaxMny()!=null? saveOrUpdateVO.getContractTaxMny() : new BigDecimal(0);
        if("子项目".equals(saveOrUpdateVO.getProjectProperty())){
            List<Long> projectIds = projectUtils.getProjectList(saveOrUpdateVO.getProjectId());
            if(projectIds!=null && projectIds.size()>0){
                QueryWrapper<ProjectTargetcostEntity> wrappera = new QueryWrapper<>();
                wrappera.in("project_id", projectIds);
                List<ProjectTargetcostEntity> lsit = projectTargetcostService.list(wrappera);
                if(lsit!=null && lsit.size()>0){
                    BigDecimal amont = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                    for(ProjectTargetcostEntity vo : lsit){
                        BigDecimal allocateContractMny = vo.getAllocateContractMny()!=null ? vo.getAllocateContractMny() : new BigDecimal(0);
                        amont = amont.add(allocateContractMny);
                    }
                    if(amont.compareTo(contractMny)>0){
                        throw new BusinessException("子项目累计分配额【"+amont.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                    }
                }
            }else{
                BigDecimal allocateContractMny = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
                if(allocateContractMny.compareTo(contractMny)>0){
                    throw new BusinessException("子项目累计分配额【"+allocateContractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                }
            }
        }else{
            BigDecimal allocateContractMny = saveOrUpdateVO.getAllocateContractMny()!=null ? saveOrUpdateVO.getAllocateContractMny() : new BigDecimal(0);
            if(allocateContractMny.compareTo(contractMny)>0){
                throw new BusinessException("子项目累计分配额【"+allocateContractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超合同额【"+contractMny.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
            }
        }
        engdepartRespcostService.checkAmount(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getProjectProperty(), saveOrUpdateVO.getTargetcostTotal());

        if(entity.getProjectTargetcostChangeDetailList()!=null && entity.getProjectTargetcostChangeDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getProjectTargetcostChangeDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setTargetcostChangeId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTargetcostChangeDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
        this.saveOrUpdate(entity, false);

        ProjectTargetcostEntity targetcostEntity = projectTargetcostService.selectById(entity.getTaskcostId());
        targetcostEntity.setChangeState("2");//状态改为变更中
        targetcostEntity.setChangeId(entity.getId());
        projectTargetcostService.saveOrUpdate(targetcostEntity, false);

        ProjectTargetcostChangeVO vo = BeanMapper.map(entity, ProjectTargetcostChangeVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTargetcostChangeDetailList())) {
            sortIntMethod(vo.getProjectTargetcostChangeDetailList());
            List<ProjectTargetcostChangeDetailVO> detailVOS = createTreeData(vo.getProjectTargetcostChangeDetailList());
            vo.setProjectTargetcostChangeDetailList(detailVOS);
        }
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<String> delete(List<ProjectTargetcostChangeVO> vos) {
        for(ProjectTargetcostChangeVO vo : vos){
            ProjectTargetcostChangeEntity entity = this.getById(vo.getId());
            ProjectTargetcostEntity targetcostEntity = projectTargetcostService.selectById(entity.getTaskcostId());
            QueryWrapper<ProjectTargetcostRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("taskcost_id", targetcostEntity.getId());
            List<ProjectTargetcostRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                targetcostEntity.setChangeState("3");//状态改为已变更
            }else{
                targetcostEntity.setChangeState("1");//状态改为未变更
            }
            targetcostEntity.setChangeId(null);
            projectTargetcostService.saveOrUpdate(targetcostEntity, false);
        }
        this.removeByIds(vos.stream().map(ProjectTargetcostChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> queryDetail(Long id) {
        ProjectTargetcostChangeEntity entity = this.selectById(id);
        ProjectTargetcostChangeVO vo = BeanMapper.map(entity, ProjectTargetcostChangeVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTargetcostChangeDetailList())) {
            sortIntMethod(vo.getProjectTargetcostChangeDetailList());
            List<ProjectTargetcostChangeDetailVO> detailVOS = createTreeData(vo.getProjectTargetcostChangeDetailList());
            vo.setProjectTargetcostChangeDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @Override
    public CommonResponse<ProjectTargetcostChangeVO> queryDetailByTargetcostId(Long targetcostId) {
        ProjectTargetcostEntity targetcostEntity = projectTargetcostService.selectById(targetcostId);
        //获取历史版本条数
        QueryWrapper<ProjectTargetcostRecordEntity> recordWrapper = new QueryWrapper<>();
        recordWrapper.eq("taskcost_id", targetcostId);
        recordWrapper.eq("dr", 0);
        Integer count = recordService.count(recordWrapper);

        ProjectTargetcostChangeVO changeVO = BeanMapper.map(targetcostEntity, ProjectTargetcostChangeVO.class);
        Long id = IdWorker.getId();
        changeVO.setTaskcostId(targetcostId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setCodeVersion(targetcostEntity.getBillCode()+"-"+(count+1));
        changeVO.setBillCode(targetcostEntity.getBillCode());
        changeVO.setId(id);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
            List<ProjectTargetcostChangeDetailVO> projectTargetcostChangeDetailList = new ArrayList<>(); //
            Map<String, Long> map = new HashMap<>();
            for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                ProjectTargetcostChangeDetailVO d = new ProjectTargetcostChangeDetailVO();

                d.setFeeType(detail.getFeeType());
                d.setRespcostDetailId(detail.getRespcostDetailId());
                d.setTargetcostDetailId(detail.getId());
                d.setRowState("add");
                d.setId(IdWorker.getId());
                d.setSubjectId(detail.getSubjectId());
                d.setSubjectCode(detail.getSubjectCode());
                d.setSubjectName(detail.getSubjectName());
                d.setFeeType(detail.getFeeType());
                d.setAmount(detail.getAmount());
                d.setCostAmount(detail.getCostAmount());
                d.setCode(detail.getCode());
                d.setAddState(detail.getAddState());
                d.setRemark(detail.getRemark());
                map.put(detail.getCode(), d.getId());
                projectTargetcostChangeDetailList.add(d);
            }
            projectTargetcostChangeDetailList.forEach(item -> {
                if(item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
            sortIntMethod(projectTargetcostChangeDetailList);
            List<ProjectTargetcostChangeDetailVO> detailVOS = createTreeData(projectTargetcostChangeDetailList);
            changeVO.setProjectTargetcostChangeDetailList(detailVOS);
        }

        return CommonResponse.success(changeVO);
    }


    private static void sortIntMethod(List<ProjectTargetcostChangeDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTargetcostChangeDetailVO o1Detail = objectMapper.convertValue(o1, ProjectTargetcostChangeDetailVO.class);
                ProjectTargetcostChangeDetailVO o2Detail = objectMapper.convertValue(o2, ProjectTargetcostChangeDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTargetcostChangeDetailVO> createTreeData(List<ProjectTargetcostChangeDetailVO> list) {
        List<ProjectTargetcostChangeDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ProjectTargetcostChangeDetailVO> listMap = new HashMap<>();
        for(ProjectTargetcostChangeDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ProjectTargetcostChangeDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            ProjectTargetcostChangeDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ProjectTargetcostChangeDetailVO> child = (List<ProjectTargetcostChangeDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ProjectTargetcostChangeDetailVO> children = new ArrayList<ProjectTargetcostChangeDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}
