package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ProjectTaskBookDetailEntity;
import com.ejianc.business.cost.bean.ProjectTaskBookEntity;
import com.ejianc.business.cost.vo.ProjectTaskBookDetailVO;
import com.ejianc.business.cost.vo.ProjectTaskBookVO;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.enums.PurchaseTypeEnum;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubRecordService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author zhangwx
 * @Date 2020/5/27
 * @Description ContractController
 */

@Controller
@RequestMapping("subContract")
public class SubContractController implements Serializable {

    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    IContractService contractService;

    @Autowired
    ISubRecordService recordService;

    @Autowired
    private IOrgApi orgApi;


    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private SessionManager sessionManager;



    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param contractVO
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubContractVO> saveOrUpdate(@RequestBody SubContractVO contractVO) {
        SubContractVO vo = contractService.insertOrUpdate(contractVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/queryRecordDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubContractVO> queryRecordDetail(Long id) {
        SubContractVO vo = recordService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ContractVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubContractVO> queryDetail(Long id) {
        SubContractVO vo = contractService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> queryList(@RequestBody QueryParam param) {
        return contractService.queryListVOs(param);
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryPageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("contractTaxMny");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(getPageQueryParam(null));
        IPage<SubContractEntity> pageData= contractService.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SubContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        logger.info(">>>>>>>>>>>>>>>>pageList开始》》》》》》");
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

       /* ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            return CommonResponse.success("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> allOrgIds = new ArrayList<>();
        List<Long> parentOrgIds = new ArrayList<>();
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        allOrgIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        allOrgIds.remove(orgId);
        allOrgIds.addAll(parentOrgIds);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, allOrgIds));
        c1.getComplexParams().add(c2);

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            List<Integer> billstate = new ArrayList<>();
            billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
            c3.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
            c1.getComplexParams().add(c3);
        }*/
        param.getComplexParams().add(getPageQueryParam(null));
        IPage<SubContractEntity> pageData= contractService.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SubContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        logger.info(">>>>>>>>>>pageList返回：" + page.toJSONString());
        return CommonResponse.success("查询列表数据成功！",page);
    }



    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubContractVO> Ids) {
        return   contractService.deleteByIds(Ids);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/contractRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> contractRef(
                @RequestParam(defaultValue = "1") Integer pageNumber,
                @RequestParam(defaultValue = "10") Integer pageSize,
                @RequestParam(value = "condition", required = false) String condition,
                @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        // 生效单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        // 已封账，不能被参照到
        queryParam.getParams().put("contractStatus", new Parameter(QueryParam.NE, 3));
        Long orgId = null;
        String type = null;
        if(StringUtils.isNotBlank(condition)) {
            logger.info("condition is " + condition);
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }

            if(null != conditionMap.get("type")) {
                type = conditionMap.get("type").toString();
            }
            if("mobileLeave".equals(type)){
                // 移动端
                if(null != conditionMap.get("projectId")) {
                    /** 项目关联合同以及集采合同 */
                    queryParam.getComplexParams().add(getPageQueryParam(orgId));
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    ComplexParam in = new ComplexParam();
                    in.setLogic(ComplexParam.AND);
                    ComplexParam p = new ComplexParam();
                    p.setLogic(ComplexParam.OR);
                    p.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                    ComplexParam t = new ComplexParam();
                    t.setLogic(ComplexParam.OR);
                    t.getParams().put("purchaseType", new Parameter(QueryParam.EQ, 2));
                    in.getComplexParams().add(p);
                    in.getComplexParams().add(t);
                    queryParam.getComplexParams().add(in);
                }
            }else if(null != conditionMap.get("projectId")) {
                queryParam.getComplexParams().add(getPageQueryParam(orgId));
//                ComplexParam c1 = new ComplexParam();
//                c1.setLogic(ComplexParam.AND);
//                ComplexParam c2 = new ComplexParam();
//                c2.setLogic(ComplexParam.OR);
//                c2.getParams().put("project_id", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
//                ComplexParam c3 = new ComplexParam();
//                c3.setLogic(ComplexParam.OR);
//                c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "2"));
//                c1.getComplexParams().add(c2);
//                c1.getComplexParams().add(c3);
//                queryParam.getComplexParams().add(c1);
//
//                if (null != conditionMap.get("orgId")){
//                    queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findParentsByOrgId(Long.parseLong(conditionMap.get("orgId").toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//                }
            }else if(null != conditionMap.get("supplierId")) {
                /** 根据项目过滤 */
                Long supplierId =  Long.valueOf(conditionMap.get("supplierId").toString());
                queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
            }
        }
        if(type != null && "pay".equals(type)){
            // 付款申请特供版
            queryParam.getComplexParams().add(getComplexParamForPay(orgId));
            //收票和付款可以参照 已封账
            queryParam.getParams().remove("contractStatus");
        } else if("mobileLeave".equals(type)){
        } else {
            queryParam.getComplexParams().add(getPageQueryParam(null));
            List<Integer> billStateList = new ArrayList<>();
            logger.debug("type is " + type);
            if(type != null && "finish".equals(type)){
                // 完工结算特供版
                queryParam.getParams().put("purchase_type", new Parameter(QueryParam.NE, PurchaseTypeEnum.公司集采.getCode()));
            }
            if(type == null || !"receive".equals(type) || !"settleReport".equals(type)){
                queryParam.getParams().put("finish_flag", new Parameter(QueryParam.NE, Boolean.TRUE));
            }
        }
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<SubContractEntity> pageData = contractService.queryPage(queryParam,false);
        IPage<SubContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<SubContractVO> contractVOS = BeanMapper.mapList(pageData.getRecords(), SubContractVO.class);
        for (SubContractVO contractVO : contractVOS) {
            contractVO.setContractNameExtend(contractVO.getBillCode()+"-"+contractVO.getContractName()+"-"+contractVO.getSupplierName()+"-"+ com.ejianc.framework.core.util.ComputeUtil.scale(contractVO.getContractTaxMny(),2));
        }
        result.setRecords(contractVOS);
        return CommonResponse.success("参照查询成功！", result);
    }



    /**
     * 合同状态修改
     *
     * @param contractVO
     * @return
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody SubContractVO contractVO) {
        LambdaUpdateWrapper<SubContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SubContractEntity::getId,contractVO.getId());
        updateWrapper.set(SubContractEntity::getContractStatus, contractVO.getContractStatus());
        contractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 合同明细参照
     *
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/refContractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> refContractDetail(@RequestParam(value = "contractId")Long contractId,
                                                                       @RequestParam(required = false) String condition) {
        List<SubContractDetailVO> contractDetailVOS = contractService.refContractDetail(contractId, condition);
        return CommonResponse.success("查询清单参照成功！", contractDetailVOS);
    }

    @RequestMapping(value = "/refContractDetailByCondition", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> refContractDetail1(@RequestParam(value = "condition") String condition) {
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        Object obj = conditionMap.get("contractId");
        Long contractId = Long.valueOf(obj.toString());
        List<SubContractDetailVO> contractDetailVOS = contractService.refContractDetail(contractId, null);
        return CommonResponse.success("查询清单参照成功！", contractDetailVOS);
    }

    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("contractTaxMny");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getComplexParams().add(getPageQueryParam(null));
        IPage<SubContractEntity> pageData= contractService.queryPage(queryParam,false);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<SubContractVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&& CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), SubContractVO.class);
        }
        list.forEach(vo -> {
            if("1".equals(vo.getContractStatus())){
                vo.setContractStatus("未签订");
            }else if("2".equals(vo.getContractStatus())){
                vo.setContractStatus("履约中");
            }else if("3".equals(vo.getContractStatus())){
                vo.setContractStatus("已封账");
            }
            vo.setPurchaseType(String.valueOf(PurchaseTypeEnum.项目自采.getCode()).equals(vo.getPurchaseType())?"自采":"集采");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("subContract-export.xlsx", beans, response);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contract-detail-import.xlsx", "分包合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return contractService.excelImport(request,response);
    }

    /**
     * 根据分包供应商主键查询分包合同
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryListBySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubContractEntity>> queryListBySupplierId(Long id) {
        QueryParam parm = new QueryParam();
        parm.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));
        List<SubContractEntity> list = contractService.queryList(parm,false);
        return CommonResponse.success("查询详情数据成功！",list);
    }

    /**
     * 传入/登录组织本下自采合同 + 登录组织本上加本下集采合同
     * @param orgId     null默认登录组织
     * @return
     */
    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 传入/登录组织本下自采合同
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "1"));
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        // 登录组织本上加本下集采合同
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if(!allOrgIds.isEmpty()){
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "2"));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    /**
     * 获取当前登录组织本上加本下的所有组织ID的集合
     * @return
     */
    public List<Long> getOrgUpToDownList(){
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("查询组织本上加本下信息失败！");
        }
        List<Long> parentIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/22  查询分包合同总金额和结算总金额
     * @Description getSubContractTotalAmount
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @RequestMapping(value = "/getSubContractTotalAmount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getSubContractTotalAmount(@RequestBody List<Long> projectIds){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("purchaseType",new Parameter(QueryParam.EQ,"1"));//属于项目
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
        if(ListUtil.isNotEmpty(projectIds)){
            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
        }
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        }
        List<SubContractEntity> contractEntities = contractService.queryList(queryParam,false);
        List<SubSettleEntity> settleEntities = settleService.queryList(queryParam,false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(contractEntities)){
            for (SubContractEntity c:contractEntities ){
                if(c.getContractTaxMny()!=null){
                    contract = contract.add(c.getContractTaxMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(settleEntities)){
            for (SubSettleEntity c:settleEntities ){
                if(c.getContractTaxMny()!=null){
                    settle = settle.add(c.getContractTaxMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        back.put("contract",contract);
        back.put("settle",settle);
        return CommonResponse.success(back);
    }

    /**
     * 统计匹配条件的（属于项目的）物资合同含税现合同金额总值(单位：万元）
     *
     * @param param
     *      projectIds: 指定所属的项目的id列表
     * @return
     */
    @PostMapping(value = "/analysisContract")
    @ResponseBody
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        QueryParam queryParam = new QueryParam();
        //查询本租户下的
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        //属于项目
        queryParam.getParams().put("purchaseType", new Parameter(QueryParam.EQ, 1));
        //已审批生效的
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        //在指定项目范围内的
        if(null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>)param.get("projectIds"))) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, param.get("projectIds")));
        }
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        }
        Map<String, Object> result = contractService.countContractAmount(queryParam);
        String dataStr = null != result.get("contractTaxMny") ? result.get("contractTaxMny").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);

        return CommonResponse.success(total.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
    }
    /**
     * 收票登记参照分包合同
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/subContractRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> subContractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            /** 移动端 有组织id 逻辑同pc端，没组织id 查租户下所有集采 */
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
                queryParam.getComplexParams().add(getPageQueryParam(orgId));
            }else{
//                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                queryParam.getComplexParams().add(getPageQueryParam(null));
            }

        }else{
//            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            queryParam.getComplexParams().add(getPageQueryParam(null));
        }
        // 生效单据
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));

        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<SubContractEntity> pageData = contractService.queryPage(queryParam,false);
        IPage<SubContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<SubContractVO> contractVOS = BeanMapper.mapList(pageData.getRecords(), SubContractVO.class);
        for (SubContractVO contractVO : contractVOS) {
            contractVO.setContractNameExtend(contractVO.getBillCode()+"-"+contractVO.getContractName()+"-"+contractVO.getSupplierName()+"-"+ com.ejianc.framework.core.util.ComputeUtil.scale(contractVO.getContractTaxMny(),2));
        }
        result.setRecords(contractVOS);
        return CommonResponse.success("参照查询成功！", result);
    }

    @RequestMapping(value = "/refSubDataTree", method = RequestMethod.GET)
    @ResponseBody
    public List<JSONObject> refSubDataTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                              String condition,
                                                              String searchObject,
                                                              String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Boolean productionFlag=false;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }else{
//                return CommonResponse.error("缺少项目参数",new ArrayList<>());
            }
            if(_con.get("productionFlag")!=null){
                productionFlag=true;
            }
        }
        List<SubContractEntity> page = contractService.queryList(param,false);
        List<JSONObject> list = new ArrayList<>();
        List<Long> haveSurNumIds = new ArrayList<>();
        if (productionFlag) {

            if (CollectionUtils.isNotEmpty(page)) {
                IPage<SubContractDetailVO> pageData = new Page<>(pageNumber, pageSize);
                QueryParam queryApplySubParam = new QueryParam();
                queryApplySubParam.getParams().put("contractId", new Parameter(QueryParam.IN, page.stream().map(SubContractEntity::getId).collect(Collectors.toList())));
                List<SubContractDetailVO> detailList =contractService.queryApplySubCount(pageData,queryApplySubParam);
                haveSurNumIds = detailList.stream().map(SubContractDetailVO::getContractId).collect(Collectors.toList());
            }
        }
        if(page!=null && page.size()>0){
            for(SubContractEntity entity : page){
                if (productionFlag&&!haveSurNumIds.contains(entity.getId())){
                    continue;
                }
                JSONObject vo = BeanMapper.map(entity, JSONObject.class);
                vo.put("name",vo.get("contractName"));
                list.add(vo);
            }
        }
        return list;
    }

    @RequestMapping(value = "/refSubDataDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubDataDetail(
            @RequestParam(defaultValue = "1") int pageNumber,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required=false) String relyCondition,
            @RequestParam(required=false) String relyNode,
            @RequestParam(required=false) String searchText,
            @RequestParam(required=false) String condition,
            @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long contractId =null;
        Boolean productionFlag=false;
        if(StringUtils.isNotBlank(relyCondition)){
            contractId=Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            if(StringUtils.isNotEmpty(condition)){
                /** 处理condition */
                JSONObject _con = JSONObject.parseObject(condition);
                if(_con.get("productionFlag")!=null){
                    productionFlag=true;
                }
            }
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<SubContractDetailVO> pageData = new Page<>(pageNumber, pageSize);
        List<SubContractDetailVO> detailList = null;
        if (productionFlag) {
            detailList =contractService.queryApplySubCount(pageData,param);
        }
        pageData.setRecords(detailList);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


}
