package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface IContractService extends IBaseService<SubContractEntity> {
    SubContractVO insertOrUpdate(SubContractVO contractVO);

    SubContractVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<String> deleteByIds(List<SubContractVO> ids);

    CommonResponse<IPage<SubContractVO>> queryListVOs(QueryParam param);

    Map<String, Object> countContractAmount(QueryParam param);

    SubContractVO queryRecordDetail(Long id, boolean b);

    List<SubContractDetailVO> refContractDetail(Long contractId, String condition);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    List<Map<String, Object>> payMnyWarn(List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> prePayMnyWarn(List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> finishMnyWarn(List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> invoicePayMnyWarn(List<SubSqlParam> sqlParamList);

    List<Map<String, Object>> invoiceContractMnyWarn(List<SubSqlParam> sqlParamList);

    List<SubWarnVo> subProjectOutMny(List<Long> tenantIds);

    List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay);

    SubProjectReportVo getSubContract(Long projectId);

    List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds);

    BigDecimal fetchSjzcje(Long projectId);


    List<SubContractDetailVO> queryApplySubCount(IPage page,QueryParam queryApplySubParam);
}
