package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 甲方报量-其他费用明细
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_zypms_income_quote_other")
public class QuoteOtherEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 甲方报量主键
     */
    @TableField("quote_id")
    private Long quoteId;

    /**
     * 费用类型
     */
    @TableField("coost_type")
    private String coostType;

    /**
     * 金额（元）
     */
    @TableField("mny")
    private BigDecimal mny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public String getCoostType() {
        return coostType;
    }

    public void setCoostType(String coostType) {
        this.coostType = coostType;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public String toString() {
        return "QuoteOtherEntity{" +
            "quoteId=" + quoteId +
            ", coostType=" + coostType +
            ", mny=" + mny +
            ", memo=" + memo +
        "}";
    }
}
