package com.ejianc.business.income.vo;

import com.ejianc.business.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ContractDetailVo extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    /**
     * 施工合同主键
     */
    private Long contractId;

    /**
     * 序号
     */
    private String detailIndex;

    /**
     * 清单编号
     */
    private String code;

    /**
     * parent_id
     */
    private Long parentId;

    /**
     * 清单名称
     */
    private String name;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 工程量
     */
    private BigDecimal num;

    /**
     * 综合单价
     */
    private BigDecimal price;

    /**
     * 合价
     */
    private BigDecimal mny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    private Integer changeType;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long changeBid;
    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;

    //累计报量
    private BigDecimal quoteNumSum;
    //累计报量金额
    private BigDecimal quotePriceSum;
    //累计报量比例
    private BigDecimal quoteScaleSum;

    private Long materialTypeId; // 物资分类id
    private String materialTypeName; // 物资分类
    private Long materialId; // 物资id
    private String spec; // 特征描述


    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public BigDecimal getQuoteNumSum() {
        return quoteNumSum;
    }

    public void setQuoteNumSum(BigDecimal quoteNumSum) {
        this.quoteNumSum = quoteNumSum;
    }

    public BigDecimal getQuotePriceSum() {
        return quotePriceSum;
    }

    public void setQuotePriceSum(BigDecimal quotePriceSum) {
        this.quotePriceSum = quotePriceSum;
    }

    public BigDecimal getQuoteScaleSum() {
        return quoteScaleSum;
    }

    public void setQuoteScaleSum(BigDecimal quoteScaleSum) {
        this.quoteScaleSum = quoteScaleSum;
    }
}
