package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.PrjcontractCostsMapper;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.service.IPrjcontractCostsDetailService;
import com.ejianc.business.cost.service.IPrjcontractCostsService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.vo.EngdepartRespcostVO;
import com.ejianc.business.cost.vo.PrjcontractCostsDetailVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 项目合同造价表
 * 
 * @author generator
 * 
 */
@Service("prjcontractCostsService")
public class PrjcontractCostsServiceImpl extends BaseServiceImpl<PrjcontractCostsMapper, PrjcontractCostsEntity> implements IPrjcontractCostsService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectTargetcostService projectTargetcostService;
    @Autowired
    private IPrjcontractCostsDetailService prjcontractCostsDetailService;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;

    private static final String BILL_CODE = "zydxPrjcontractCosts";//此处需要根据实际修改

    //根据项目目标成本生成项目合同造价表
    @Override
    public void generate(ProjectTargetcostEntity targetcostEntity) {
        PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(targetcostEntity.getProjectId());
        if(preBidCostCalcEntity==null){
            throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
        }
        PrjcontractCostsEntity entity = null;
        //判断该项目是子项目还是执行项目（即没有父项目，子项目的项目）。若是子项目，则生成父项目的【项目合同造价表】，若是执行项目，则直接修改

        Long projectId = targetcostEntity.getProjectId();
        String projectName = targetcostEntity.getProjectName();
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(targetcostEntity.getProjectId());
        ProjectRegisterVO ppvo = null;
        CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(projectIds);
        if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0){
            ProjectRegisterVO pvo = pvos.getData().get(0);
            if(pvo.getHasChild()!=null && pvo.getHasChild()){
                //是父项目
            }else{
                //是子项目，创建父项目的【项目合同造价表】
                //查询是否有该子项目的【项目合同造价表】，若存在，删除（一般来说不会存在的，以防万一）
                QueryWrapper<PrjcontractCostsEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("project_id", targetcostEntity.getProjectId());
                Integer count = this.count(wrapper);
                if(count!=null && count>0){
                    this.remove(wrapper);
                }
                //查询父项目信息
                projectId = pvo.getParentId();
                List<Long> pprojectIds = new ArrayList<>();
                pprojectIds.add(pvo.getParentId());
                CommonResponse<List<ProjectRegisterVO>> ppvos = projectApi.queryProjectByIds(pprojectIds);
                if(ppvos.isSuccess() && ppvos.getData()!=null && ppvos.getData().size()>0) {
                    ppvo = ppvos.getData().get(0);
                }
            }
        }
        //判断是否存在本项目的数据
        QueryWrapper<PrjcontractCostsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        entity = this.getOne(wrapper);
        if(entity==null){
            //不存在，新增
            entity = BeanMapper.map(targetcostEntity, PrjcontractCostsEntity.class);
            if(ppvo!=null){
                entity.setProjectId(ppvo.getId());
                entity.setProjectName(ppvo.getName());
                entity.setOrgId(ppvo.getOrgId());
                entity.setOrgName(ppvo.getOrgName());
                entity.setProjectDepartmentId(ppvo.getProjectDepartmentId());
            }
            Long id = IdWorker.getId();
            entity.setProjectTargetcostIds(targetcostEntity.getId().toString());
            entity.setConstructionCost(targetcostEntity.getTargetcostTotal());//
            entity.setPrjcostTotal(targetcostEntity.getTargetcostTotal());//全部项目直接成本
            entity.setBillState(0);
            entity.setEstablishmentDate(null);
            entity.setEstablishmentOrgId(null);
            entity.setEstablishmentOrgName(null);
            entity.setEstablishmentUserId(null);
            entity.setEstablishmentUserName(null);
            entity.setRemark(null);
            entity.setId(id);
            entity.setCreateTime(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setVersion(null);
            entity.setSyncEsFlag(null);

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, EngdepartRespcostVO.class));
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                List<PrjcontractCostsDetailEntity> engdepartRespcostDetailList = new ArrayList<>(); // 工程部责任成本明细
                Map<String, Long> map = new HashMap<>();
                for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                    PrjcontractCostsDetailEntity d = createEntity(detail,targetcostEntity.getProjectId(), projectName,id);
                    d.setCode(detail.getCode());
                    map.put(detail.getCode(), d.getId());
                    engdepartRespcostDetailList.add(d);
                }
                if(engdepartRespcostDetailList!=null && engdepartRespcostDetailList.size()>0){
                    engdepartRespcostDetailList.forEach(item -> {
                        if(item.getCode().indexOf(".")!=-1){
                            String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                            item.setPid(map.get(code));
                        }
                    });
                }
                entity.setPrjcontractCostsDetailList(engdepartRespcostDetailList);
            }
        }else{
            BigDecimal constructionCost = entity.getConstructionCost()!=null?entity.getConstructionCost():new BigDecimal(0); // 造价金额
            BigDecimal prjcostTotal = entity.getPrjcostTotal()!=null ? entity.getPrjcostTotal(): new BigDecimal(0); // 全部项目直接成本
            BigDecimal newprjcostTotal = new BigDecimal(0); // 全部项目直接成本

            QueryWrapper<PrjcontractCostsDetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("costs_id", entity.getId());
            List<PrjcontractCostsDetailEntity> dList = prjcontractCostsDetailService.list(detailWrapper);
            entity.setPrjcontractCostsDetailList(dList);

            //先给数据自定义一套id和pid的对应关系，新增的数据直接用这个id就行，存在的数据用原先的
            Map<Long, Long> idMap = new HashMap<>();
            for(PrjcontractCostsDetailEntity detail : dList){
                idMap.put(detail.getProjectTargetcostDetailId(), detail.getId());
            }
            Map<Long, ProjectTargetcostDetailEntity> newMap = new HashMap<>();
            for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                newMap.put(detail.getId(), detail);
                if(idMap.get(detail.getId())==null){
                    idMap.put(detail.getId(), IdWorker.getId());
                }
            }

            List<PrjcontractCostsDetailEntity> resultList = null;
            List<PrjcontractCostsDetailEntity> delList = new ArrayList<>();
            //该项目数据已存在
            if(entity.getProjectTargetcostIds().contains(targetcostEntity.getId().toString())){
                Map<Long, ProjectTargetcostDetailEntity> dataMap = new HashMap<>();//变更的数据
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                    for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                        dataMap.put(detail.getId(), detail);
                    }
                }
                //判断该子项目是否存在，存在，则找到对应的数据进行替换；
                //获取原先的子表数据，根据新的数据更新，根据项目过滤下，多余的新增，不存在的删除，存在的修改
                resultList = entity.getPrjcontractCostsDetailList();
                List<PrjcontractCostsDetailEntity> addList = new ArrayList<>();
                Map<Long, PrjcontractCostsDetailEntity> exitDataMap = new HashMap<>();
                List<String> subjectCode = new ArrayList<>();
                for(PrjcontractCostsDetailEntity de : resultList){
                    if(StringUtils.isNotBlank(de.getSubjectCode())){
                        subjectCode.add(de.getSubjectCode());
                    }
                    if(targetcostEntity.getProjectId().equals(de.getProjectId())){
                        exitDataMap.put(de.getProjectTargetcostDetailId(), de);
                        if(dataMap!=null && dataMap.get(de.getProjectTargetcostDetailId())!=null){
                            ProjectTargetcostDetailEntity detail = dataMap.get(de.getProjectTargetcostDetailId());
                            //存在，要修改的数据
                            de.setCode(detail.getCode());
                            de.setAddState(detail.getAddState());
                            de.setAmount(detail.getAmount());
                            de.setFeeType(detail.getFeeType());
                            de.setProjectTargetcostDetailId(detail.getId());
                            de.setSubjectCode(detail.getSubjectCode());
                            de.setSubjectId(detail.getSubjectId());
                            de.setSubjectName(detail.getSubjectName());
                            de.setRowState("edit");
                        }else{
                            //变更的子表为空，则原先的数据全部清除
                            de.setRowState("del");
                            delList.add(de);
                        }
                    }
                }

                for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                    if(!(exitDataMap!=null && exitDataMap.get(detail.getId())!=null) && !subjectCode.contains(detail.getSubjectCode())){
                        //新的不存在，新增
                        PrjcontractCostsDetailEntity d = createEntity(detail,targetcostEntity.getProjectId(), projectName,entity.getId());
                        d.setId(idMap.get(detail.getId()));
                        if(detail.getPid()!=null){
                            d.setPid(idMap.get(detail.getPid()));
                        }
                        addList.add(d);
                    }
                }
                resultList.addAll(addList);
                resultList.removeAll(delList);
            }else{
                entity.setProjectTargetcostIds(entity.getProjectTargetcostIds()+","+targetcostEntity.getId().toString());
                resultList = BeanMapper.mapList(entity.getPrjcontractCostsDetailList(), PrjcontractCostsDetailEntity.class);
                //先将原有的项目的子表数据按照map存储，对应key为成本档案的id，得到数据为map1
                List<PrjcontractCostsDetailEntity> detailList = entity.getPrjcontractCostsDetailList();
                Map<Long, PrjcontractCostsDetailEntity> map1 = new HashMap<>();

                for(PrjcontractCostsDetailEntity de : detailList){
                    if(de.getSubjectId()!=null && !(de.getAddState()!=null && de.getAddState())){
                        map1.put(de.getSubjectId(), de);
                    }else{
                        //非成本科目档案数据
                        map1.put(de.getId(), de);
                    }
                }
                //遍历新数据，判断新数据是否在原先的数据中
                //1、若存在，并且该数据不是叶子节点，忽略
                //2、若存在，该数据是叶子节点，需要添加到新增的数据中
                //3、不存在，则直接新增该数据

                //获取有孩子节点的父节点数据id
                List<Long> hasChildList = new ArrayList<>();
                for(ProjectTargetcostDetailEntity de : targetcostEntity.getProjectTargetcostDetailList()){
                    if(de.getPid()!=null && !hasChildList.contains(de.getPid())){
                        hasChildList.add(de.getPid());
                    }
                }

                //先将项目目标成本的子表数据按照map存储，对应key为成本档案的id，得到数据为map2
                Map<Long, ProjectTargetcostDetailEntity> map2 = new HashMap<>();
                for(ProjectTargetcostDetailEntity de : targetcostEntity.getProjectTargetcostDetailList()){
                    Long subjectId = null;
                    if(de.getSubjectId()!=null && !(de.getAddState()!=null && de.getAddState())){
                        subjectId = de.getSubjectId();
                        map2.put(de.getSubjectId(), de);
                    }else{
                        subjectId = de.getId();
                        //非成本科目档案数据
                        map2.put(de.getId(), de);
                    }
                    if(map1.get(subjectId)!=null){
                        //1、若存在，并且该数据不是叶子节点，忽略
                        //2、若存在，该数据是叶子节点，需要添加到新增的数据中
                        if(!hasChildList.contains(de.getId())){
                            PrjcontractCostsDetailEntity d = createEntity(de,targetcostEntity.getProjectId(), projectName,entity.getId());

                            resultList.add(d);
                        }
                    }else{
                        PrjcontractCostsDetailEntity d = createEntity(de,targetcostEntity.getProjectId(), projectName,entity.getId());
                        //3、不存在，且父节点也不在原先的数据中，则直接新增该数据
                        //4、不存在，若父节点在原先的数据中，则修改pid为原先数据的id,然后新增该数据
                        d.setId(idMap.get(de.getId()));
                        if(de.getPid()!=null){
                            ProjectTargetcostDetailEntity pData = newMap.get(de.getPid());
                            Long psubjectId = null;
                            if(pData.getSubjectId()!=null && !(pData.getAddState()!=null && pData.getAddState())){
                                psubjectId = pData.getSubjectId();
                            }else{
                                //非成本科目档案数据
                                psubjectId = pData.getId();
                            }
                            if(map1.get(psubjectId)!=null){
                                //若父节点在原先的数据中，则修改pid为原先数据的id,然后新增该数据
                                d.setPid(map1.get(psubjectId).getId());
                            }else{
                                d.setPid(idMap.get(de.getPid()));
                            }
                        }
                        resultList.add(d);
                    }
                }
            }

            //获取所有重复的叶子节点的数据
            LinkedHashMap<Long, List<PrjcontractCostsDetailEntity>> subMap = new LinkedHashMap<>();
            LinkedHashMap<Long, List<PrjcontractCostsDetailEntity>> lastChildMap = new LinkedHashMap<>();
            List<Long> exitAddId = new ArrayList<>();
            for(PrjcontractCostsDetailEntity de : resultList){
                if(de.getSubjectId()!=null){
                    if(subMap.get(de.getSubjectId())!=null){
                        //过滤调之前项目的手动生成的叶子节点
                        if(de.getProjectTargetcostDetailId()!=null){
                            subMap.get(de.getSubjectId()).add(de);
                            lastChildMap.put(de.getSubjectId(), subMap.get(de.getSubjectId()));
                        }else{
                            //该节点是之前手动生成的，若后面数据存在该叶子节点的数据，则不需要再手动生成了
                            exitAddId.add(de.getSubjectId());
                        }
                    }else{
                        List<PrjcontractCostsDetailEntity> a = new ArrayList<>();
                        a.add(de);
                        subMap.put(de.getSubjectId(), a);
                    }
                }
            }
            //判断叶子节点是否原数据已生成虚拟的父节点，若是，则将该节点的父级节点改为其节点的父id，否则生成虚拟节点，并修改之前节点的pid
            for(Long subId : lastChildMap.keySet()){
                if(!exitAddId.contains(subId)){
                    //生成虚拟节点，并修改之前节点的pid
                    PrjcontractCostsDetailEntity de = null;
                    Long id = IdWorker.getId();
                    Long pid = null;
                    for(PrjcontractCostsDetailEntity a : lastChildMap.get(subId)){
                        if(de == null && !(StringUtils.isNotBlank(a.getRowState()) && "add".equals(a.getRowState()))){
                            de = lastChildMap.get(subId).get(0);//取原先单据中的相应的叶子节点数据
                        }
                        if(pid==null) pid = de.getPid();
                        a.setPid(id);
                    }
                    //手动构建多个叶子的节点的上级数据
                    PrjcontractCostsDetailEntity d = new PrjcontractCostsDetailEntity();
                    d.setAddState(de.getAddState());
                    d.setFeeType(de.getFeeType());
                    d.setSubjectCode(de.getSubjectCode());
                    d.setSubjectId(de.getSubjectId());
                    d.setSubjectName(de.getSubjectName());
                    d.setSubjectInnerCode(de.getSubjectInnerCode());
                    d.setParentInnerCode(de.getParentInnerCode());
//                    d.setProjectId(targetcostEntity.getProjectId());
//                    d.setProjectName(targetcostEntity.getProjectName());
                    d.setCostsId(entity.getId());
                    d.setPid(pid);
                    d.setRowState("add");
                    d.setId(id);
                    resultList.add(d);
                }else{
                    //将该节点的父级节点改为其节点的父id
                    PrjcontractCostsDetailEntity de = null;
                    for(PrjcontractCostsDetailEntity a : lastChildMap.get(subId)){
                        if(a.getProjectId().equals(targetcostEntity.getProjectId())){
                            de = lastChildMap.get(subId).get(0);//取原先单据中的相应的叶子节点数据
                            for (PrjcontractCostsDetailEntity q : resultList){
                                if(q.getProjectTargetcostDetailId()!=null && a.getProjectTargetcostDetailId()!=null
                                        && q.getProjectTargetcostDetailId().equals(a.getProjectTargetcostDetailId())){
                                    q.setPid(de.getPid());
                                }
                            }
                            break;
                        }

                    }
                }
            }
            //根据pid重新构建innercode
            //1、先排序，顺序：成本档案subjectInnerCode，项目id，id(手动新增的)
            //2、根据pid构建成树，
            //3、根据树生成code
            if(CollectionUtils.isNotEmpty(resultList)){
                resultList.sort(Comparator.comparing(PrjcontractCostsDetailEntity::getSubjectInnerCode,Comparator.nullsLast(String::compareTo))
                        .thenComparing(PrjcontractCostsDetailEntity::getProjectId,Comparator.nullsLast(Long::compare))
                        .thenComparing(PrjcontractCostsDetailEntity::getId,Comparator.nullsLast(Long::compare)));
                List<PrjcontractCostsDetailVO> tree1 = BeanMapper.mapList(resultList, PrjcontractCostsDetailVO.class);
//                for (PrjcontractCostsDetailVO vo : tree1){
//                    System.out.println(BeanMapper.map(vo, JSONObject.class).toJSONString());
//                }
                tree1 = createTreeData1(tree1);
                //然后得到的新的数据【树3】，汇总计算值，--并同时计算code值
                for(int i=0; i<tree1.size(); i++){
                    PrjcontractCostsDetailVO vo = tree1.get(i);
                    String code = String.valueOf(i + 1);
                    vo.setCode(code);
                    BigDecimal camount = addAllAmount(vo, code);
                    vo.setAmount(camount);
                }
                //将树数据转成entity并赋值到vo中
                List<PrjcontractCostsDetailEntity> entities = new ArrayList<>();
                for(PrjcontractCostsDetailVO vo : tree1){
                    entities.add(BeanMapper.map(vo, PrjcontractCostsDetailEntity.class));
                    tranData(entities,vo);
                }
                entities.addAll(delList);
                entity.setPrjcontractCostsDetailList(entities);
            }else if(CollectionUtils.isNotEmpty(delList)){
                entity.setPrjcontractCostsDetailList(delList);
            }

            //获取其他的项目数据，合计极端项目成本
            QueryWrapper<ProjectTargetcostEntity> pwrapper = new QueryWrapper<>();
            pwrapper.in("id", entity.getProjectTargetcostIds().split(","));
            List<ProjectTargetcostEntity> list = projectTargetcostService.list(pwrapper);
            if(list!=null && list.size()>0){
                for(ProjectTargetcostEntity en : list){
                    if(!en.getProjectId().equals(targetcostEntity.getProjectId())){
                        newprjcostTotal = newprjcostTotal.add(en.getTargetcostTotal());
                    }else{
                        newprjcostTotal = newprjcostTotal.add(targetcostEntity.getTargetcostTotal());
                    }
                }
            }
            constructionCost = constructionCost.subtract(prjcostTotal).add(newprjcostTotal);
            entity.setConstructionCost(constructionCost);
            entity.setPrjcostTotal(newprjcostTotal);
        }

        entity.setPrebidId(preBidCostCalcEntity.getId());
        entity.setPrebidCost(preBidCostCalcEntity.getCostTaxTotal());
        this.saveOrUpdate(entity, false);

    }

    //项目目标成本弃审删除合同造价表
    @Override
    public void backData(ProjectTargetcostEntity targetcostEntity) {
        //判断是否存在本项目的数据
        QueryWrapper<PrjcontractCostsEntity> wrapper = new QueryWrapper<>();
        wrapper.like("prjcontract_targetcost_ids", targetcostEntity.getId());
        PrjcontractCostsEntity entity = this.getOne(wrapper);
        if(entity!=null){
            if(entity.getBillState()==0){
                if(targetcostEntity.getId().toString().equals(entity.getProjectTargetcostIds())){
                    //就一个，清理全部数据
                    QueryWrapper<PrjcontractCostsDetailEntity> detailWrapper = new QueryWrapper<>();
                    detailWrapper.eq("costs_id", entity.getId());
                    prjcontractCostsDetailService.remove(detailWrapper);
                    this.removeById(entity.getId());
                }else{
                    //有其他子项目的数据
                    if(targetcostEntity.getProjectTargetcostDetailList()!=null && targetcostEntity.getProjectTargetcostDetailList().size()>0){
                        List<Long> detailIds = new ArrayList<>();
                        for(ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()){
                            detailIds.add(detail.getId());
                        }

                        QueryWrapper<PrjcontractCostsDetailEntity> detailWrapper = new QueryWrapper<>();
                        detailWrapper.eq("costs_id", entity.getId());
                        List<PrjcontractCostsDetailEntity> dList = prjcontractCostsDetailService.list(detailWrapper);

                        Map<Long, PrjcontractCostsDetailEntity> allMap = new HashMap<>();
                        List<Long> delDetailIds = new ArrayList<>();
                        List<PrjcontractCostsDetailEntity> delList = new ArrayList<>();
                        List<Long> delSubIds = new ArrayList<>();
                        List<PrjcontractCostsDetailEntity> remainList = new ArrayList<>();
                        for (PrjcontractCostsDetailEntity en : dList) {
                            allMap.put(en.getId(), en);
                            if(en.getProjectTargetcostDetailId()!=null && detailIds.contains(en.getProjectTargetcostDetailId())){
                                delDetailIds.add(en.getId());
                                delSubIds.add(en.getSubjectId());
                                en.setRowState("del");
                                delList.add(en);
                            }else{
                                remainList.add(en);
                            }
                        }

                        //丛剩下的里面判断该档案是否是虚拟生成的，且下级没有其他项目的成本科目
                        //1、遍历剩下数据
                        //2、根据要删除的成本档案id（delSubIds）来进行判断，
                        //2.1、若本项数据的成本科目id在delSubIds中，且只有一条虚拟的数据，则该数据是要被删除的
                        Map<Long, List<PrjcontractCostsDetailEntity>> subMap = new HashMap<>();
                        for (PrjcontractCostsDetailEntity en : remainList) {
                            if(en.getSubjectId()!=null && delSubIds.contains(en.getSubjectId())){
                                if(subMap.get(en.getSubjectId())!=null){
                                    List<PrjcontractCostsDetailEntity> li = subMap.get(en.getSubjectId());
                                    li.add(en);
                                    subMap.put(en.getSubjectId(), li);
                                }else{
                                    List<PrjcontractCostsDetailEntity> li = new ArrayList<>();
                                    li.add(en);
                                    subMap.put(en.getSubjectId(), li);
                                }
                            }
                        }

                        for(Long subId : subMap.keySet()){
                            List<PrjcontractCostsDetailEntity> li = subMap.get(subId);
                            if(li.size()==1 && li.get(0).getProjectTargetcostDetailId() == null){
                                li.get(0).setRowState("del");
                                delList.add(li.get(0));
                                delDetailIds.add(li.get(0).getId());
                            }
                        }

                        //获取最新的最后剩下的数据
                        List<PrjcontractCostsDetailEntity> remainList2 = new ArrayList<>();
                        for (PrjcontractCostsDetailEntity en : dList) {
                            if(!delDetailIds.contains(en.getId())){
                                remainList2.add(en);
                            }
                        }
                        //去除没有子节点的父节点的数据
                        if(remainList2!=null && remainList2.size()>0){
                            List<PrjcontractCostsDetailVO> tree1 = createTreeData1(BeanMapper.mapList(remainList2, PrjcontractCostsDetailVO.class));
                            //判断该叶子节点是否是虚拟的叶子节点，若是金额置空
                            dealTreeData(tree1);
                            for(int i=0; i<tree1.size(); i++){
                                PrjcontractCostsDetailVO vo = tree1.get(i);
                                String code = String.valueOf(i + 1);
                                vo.setCode(code);
                                BigDecimal camount = addAllAmount(vo, code);
                                vo.setAmount(camount);
                            }
                            //将树数据转成entity并赋值到vo中
                            List<PrjcontractCostsDetailEntity> entities = new ArrayList<>();
                            for(PrjcontractCostsDetailVO vo : tree1){
                                entities.add(BeanMapper.map(vo, PrjcontractCostsDetailEntity.class));
                                tranData(entities,vo);
                            }
                            entities.addAll(delList);
                            entity.setPrjcontractCostsDetailList(entities);
                        }

                    }
                    String[] projectTargetcostIds = entity.getProjectTargetcostIds().split(",");
                    List<String> fruitsList = new ArrayList<>(Arrays.asList(projectTargetcostIds));
                    fruitsList.remove(targetcostEntity.getId().toString());


                    BigDecimal constructionCost = entity.getConstructionCost()!=null?entity.getConstructionCost():new BigDecimal(0); // 造价金额
                    BigDecimal prjcostTotal = entity.getPrjcostTotal()!=null ? entity.getPrjcostTotal(): new BigDecimal(0); // 全部项目直接成本
                    BigDecimal newprjcostTotal = new BigDecimal(0); // 全部项目直接成本
                    //获取其他的项目数据，合计极端项目成本
                    QueryWrapper<ProjectTargetcostEntity> pwrapper = new QueryWrapper<>();
                    pwrapper.in("id", fruitsList);
                    List<ProjectTargetcostEntity> list = projectTargetcostService.list(pwrapper);
                    if(list!=null && list.size()>0){
                        for(ProjectTargetcostEntity en : list){
                            newprjcostTotal = newprjcostTotal.add(en.getTargetcostTotal());
                        }
                    }
                    entity.setProjectTargetcostIds(String.join(",", fruitsList));
                    constructionCost = constructionCost.subtract(newprjcostTotal.subtract(prjcostTotal));//造价金额 = 造价金额（旧）-（项目直接成本（新）-项目直接成本（旧））
                    entity.setConstructionCost(constructionCost);
                    entity.setPrjcostTotal(newprjcostTotal);

                    this.saveOrUpdate(entity, false);
                }
            }else{
                throw new BusinessException("该单据生成的项目合同造价表且已提交，不允许弃审");
            }
        }
    }

    private void dealTreeData(List<PrjcontractCostsDetailVO> tree1) {
        if(tree1!=null && tree1.size()>0){
            tree1.forEach(item -> {
                if(item.getChildren()!=null && item.getChildren().size()>0){
                    dealTreeData(item.getChildren());
                }else{
                    //不是实际的成本的叶子节点，金额置空
                    if(item.getProjectTargetcostDetailId() == null){
                        item.setAmount(new BigDecimal(0));
                    }
                }
            });
        }
    }

    private void tranData(List<PrjcontractCostsDetailEntity> entities, PrjcontractCostsDetailVO vo) {
        if(vo.getChildren()!=null && vo.getChildren().size()>0){
            for(PrjcontractCostsDetailVO c : vo.getChildren()){
                entities.add(BeanMapper.map(c, PrjcontractCostsDetailEntity.class));
                tranData(entities,c);
            }
        }
    }

    private PrjcontractCostsDetailEntity createEntity(ProjectTargetcostDetailEntity de, Long projectId, String projectName, Long costsId){
        PrjcontractCostsDetailEntity d = new PrjcontractCostsDetailEntity();
        d.setAddState(de.getAddState());
        d.setAmount(de.getAmount());
        d.setFeeType(de.getFeeType());
        d.setProjectId(projectId);
        d.setProjectName(projectName);
        d.setProjectTargetcostDetailId(de.getId());
        d.setSubjectCode(de.getSubjectCode());
        d.setSubjectId(de.getSubjectId());
        d.setSubjectName(de.getSubjectName());
        d.setSubjectInnerCode(de.getSubjectInnerCode());
        d.setParentInnerCode(de.getParentInnerCode());
        d.setCostsId(costsId);
        d.setRowState("add");
        d.setId(IdWorker.getId());
        return d;
    }

    public List<PrjcontractCostsDetailVO> createTreeData1(List<PrjcontractCostsDetailVO> list) {
        List<PrjcontractCostsDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PrjcontractCostsDetailVO> listMap = new HashMap<>();
        for(PrjcontractCostsDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            PrjcontractCostsDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            PrjcontractCostsDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<PrjcontractCostsDetailVO> child = (List<PrjcontractCostsDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<PrjcontractCostsDetailVO> children = new ArrayList<PrjcontractCostsDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private BigDecimal addAllAmount(PrjcontractCostsDetailVO vo, String pcode){
        BigDecimal amount = vo.getAmount()!=null ? vo.getAmount() : new BigDecimal(0);
        if(vo.getChildren()!=null && vo.getChildren().size()>0){
            vo.setProjectTargetcostDetailId(null);
            vo.setProjectId(null);
            vo.setProjectName(null);
            amount = new BigDecimal(0);
            for(int i=0; i<vo.getChildren().size(); i++){
                PrjcontractCostsDetailVO c = vo.getChildren().get(i);
                String code = null;
                if(StringUtils.isNotBlank(pcode)){
                    code = pcode +"." + (i+1);
                }else{
                    code = String.valueOf(i+1);
                }
                c.setCode(code);
                BigDecimal camount = addAllAmount(c, code);
                amount = amount.add(camount);
            }
            vo.setAmount(amount);
        }
        return amount;
    }


}
