package com.ejianc.business.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * （项目/厂矿/车间）境内境外生产情况统计表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_production_in_out_info")
public class ProductionInOutInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 生产单位
    @TableField(value="org_name")
    private String orgName; // 生产单位
    @TableField(value="name")
    private String name; // 项目/厂矿/车间名称
    @TableField(value="pro_state")
    private String proState; // 状态:新开new、在施build、暂停stop、复工rework、完工finish
    @TableField(value="pro_type")
    private String proType; // 类别：项目project、厂矿factory、车间shop
    @TableField(value="contract_money")
    private BigDecimal contractMoney; // 合同额（万元）
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="rework_date")
    private Date reworkDate; // 复工日期
    @TableField(value="do_sign")
    private Boolean doSign; // 是否签订合同及安全生产协议
    @TableField(value="do_check")
    private Boolean doCheck; // 是否开展安全生产开/复工检查
    @TableField(value="do_edu")
    private Boolean doEdu; // 是否进行安全教育培训
    @TableField(value="scene_manger_num")
    private Integer sceneMangerNum; // 现场管理人员人数
    @TableField(value="scene_work_num")
    private Integer sceneWorkNum; // 现场施工作业人员人数
    @TableField(value="connect_info")
    private String connectInfo; // 联系人及电话
    @TableField(value="job_do_unit")
    private String jobDoUnit; // 任务承接单位
    @TableField(value="scene_safer")
    private String sceneSafer; // 现场专（兼）职安全员及联系方式
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="production_job")
    private String productionJob; // 生产任务
    @TableField(value="memo")
    private String memo; // 备注
    
    
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getProState() {
        return proState;
    }

    public void setProState(String proState) {
        this.proState = proState;
    }
    public String getProType() {
        return proType;
    }

    public void setProType(String proType) {
        this.proType = proType;
    }
    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getReworkDate() {
        return reworkDate;
    }

    public void setReworkDate(Date reworkDate) {
        this.reworkDate = reworkDate;
    }
    public Boolean getDoSign() {
        return doSign;
    }

    public void setDoSign(Boolean doSign) {
        this.doSign = doSign;
    }
    public Boolean getDoCheck() {
        return doCheck;
    }

    public void setDoCheck(Boolean doCheck) {
        this.doCheck = doCheck;
    }
    public Boolean getDoEdu() {
        return doEdu;
    }

    public void setDoEdu(Boolean doEdu) {
        this.doEdu = doEdu;
    }
    public Integer getSceneMangerNum() {
        return sceneMangerNum;
    }

    public void setSceneMangerNum(Integer sceneMangerNum) {
        this.sceneMangerNum = sceneMangerNum;
    }
    public Integer getSceneWorkNum() {
        return sceneWorkNum;
    }

    public void setSceneWorkNum(Integer sceneWorkNum) {
        this.sceneWorkNum = sceneWorkNum;
    }
    public String getConnectInfo() {
        return connectInfo;
    }

    public void setConnectInfo(String connectInfo) {
        this.connectInfo = connectInfo;
    }
    public String getJobDoUnit() {
        return jobDoUnit;
    }

    public void setJobDoUnit(String jobDoUnit) {
        this.jobDoUnit = jobDoUnit;
    }
    public String getSceneSafer() {
        return sceneSafer;
    }

    public void setSceneSafer(String sceneSafer) {
        this.sceneSafer = sceneSafer;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProductionJob() {
        return productionJob;
    }

    public void setProductionJob(String productionJob) {
        this.productionJob = productionJob;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
