package com.ejianc.business.other.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 其他支出合同变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_other_contract_change")
public class OtherContractChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_status")
    private String contractStatus; // 合同状态：1-未签订, 2-履约中，3-已封帐
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="customer_id")
    private Long customerId; // 甲方
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="sign_date")
    private java.util.Date signDate; // 签约日期
    @TableField(value="contract_type")
    private Long contractType; // 合同类型
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    /**
     * 合同优惠前金额
     */
    @TableField(value = "contract_undiscount_mny")
    private BigDecimal contractUndiscountMny;

    /**
     * 优惠金额
     */
    @TableField(value = "discount_mny")
    private BigDecimal discountMny;
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value="base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_time")
    private java.util.Date changeTime; // 变更（编制）时间
    @TableField(value="used_time")
    private java.util.Date usedTime; // 生效时间
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;
    
    @TableField(exist=false)
    @SubEntity(serviceName="otherContractDetailChangeService",pidName = "changeId")
    private List<OtherContractDetailChangeEntity> detailVos = new ArrayList<>(); // 其他支出合同清单变更
    @TableField(exist=false)
    @SubEntity(serviceName="otherContractPayPlanChangeService",pidName = "changeId")
    private List<OtherContractPayPlanChangeEntity> payPlanVos = new ArrayList<>(); // 其他支出付款计划变更
    @TableField(exist=false)
    @SubEntity(serviceName="otherContractClauseChangeService",pidName = "changeId")
    private List<OtherContractClauseChangeEntity> clauseVos = new ArrayList<>(); // 其他支出合同条款变更


    /**
     * 是否属于项目: 1-是（默认），0-否
     */
    @TableField(value = "depend_on_project")
    private Integer dependOnProject;

    /**
     * 采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    @TableField(value = "purchase_mode")
    private Integer purchaseMode;
    /**
     * 采购方式名称
     */
    @TableField(value = "purchase_mode_name")
    private String purchaseModeName;

    /**
     * 定标结果单id
     */
    @TableField(value = "enquiry_price_bill_id")
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    @TableField(value = "enquiry_price_bill_name")
    private String enquiryPriceBillName;

    //联系人
    @TableField(value = "link_user")
    private String linkUser;
    //联系电话
    @TableField(value = "link_phone")
    private String linkPhone;
    //合同内容
    @TableField(value = "contract_content")
    private String contractContent;
    //户名
    @TableField(value = "account_name")
    private String accountName;
    // 账号
    @TableField(value = "account_no")
    private String accountNo;
    //开户行
    @TableField(value = "open_bank")
    private String openBank;

    @TableField(value="b_change_mny")
    private BigDecimal bChangeMny; // 本次变更金额
    @TableField(value="b_change_rate")
    private BigDecimal bChangeRate; // 本次变更比例

    public BigDecimal getbChangeMny() {
        return bChangeMny;
    }

    public void setbChangeMny(BigDecimal bChangeMny) {
        this.bChangeMny = bChangeMny;
    }

    public BigDecimal getbChangeRate() {
        return bChangeRate;
    }

    public void setbChangeRate(BigDecimal bChangeRate) {
        this.bChangeRate = bChangeRate;
    }

    public String getLinkUser() {
        return linkUser;
    }

    public void setLinkUser(String linkUser) {
        this.linkUser = linkUser;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNo() {
        return accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public String getOpenBank() {
        return openBank;
    }

    public void setOpenBank(String openBank) {
        this.openBank = openBank;
    }

    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }


    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(Integer purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public String getPurchaseModeName() {
        return purchaseModeName;
    }

    public void setPurchaseModeName(String purchaseModeName) {
        this.purchaseModeName = purchaseModeName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public String getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-未签订, 2-履约中，3-已封帐
     */
    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 甲方
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 甲方
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    public BigDecimal getContractUndiscountMny() {
        return contractUndiscountMny;
    }

    public void setContractUndiscountMny(BigDecimal contractUndiscountMny) {
        this.contractUndiscountMny = contractUndiscountMny;
    }

    public BigDecimal getDiscountMny() {
        return discountMny;
    }

    public void setDiscountMny(BigDecimal discountMny) {
        this.discountMny = discountMny;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 合同类型
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 税金
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更（编制）时间
     */
    public java.util.Date getChangeTime() {
        return changeTime;
    }

    /**
     * 变更（编制）时间
     */
    public void setChangeTime(java.util.Date changeTime) {
        this.changeTime = changeTime;
    }
    /**
     * 生效时间
     */
    public java.util.Date getUsedTime() {
        return usedTime;
    }

    /**
     * 生效时间
     */
    public void setUsedTime(java.util.Date usedTime) {
        this.usedTime = usedTime;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public List<OtherContractDetailChangeEntity> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<OtherContractDetailChangeEntity> detailVos) {
        this.detailVos = detailVos;
    }

    public List<OtherContractPayPlanChangeEntity> getPayPlanVos() {
        return payPlanVos;
    }

    public void setPayPlanVos(List<OtherContractPayPlanChangeEntity> payPlanVos) {
        this.payPlanVos = payPlanVos;
    }

    public List<OtherContractClauseChangeEntity> getClauseVos() {
        return clauseVos;
    }

    public void setClauseVos(List<OtherContractClauseChangeEntity> clauseVos) {
        this.clauseVos = clauseVos;
    }
}
