/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubFinishService;
import com.ejianc.business.sub.vo.SubFinishRecordVO;
import com.ejianc.business.sub.vo.SubFinishVO;
import com.ejianc.business.sub.vo.SubParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subFinish"})
public class SubFinishController
implements Serializable {
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISubFinishService finishService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubFinishVO> saveOrUpdate(@RequestBody SubFinishVO finishVO) {
        SubFinishVO vo = this.finishService.insertOrUpdate(finishVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubFinishVO> queryDetail(Long id) {
        SubFinishVO vo = this.finishService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        CommonResponse<SubFinishVO> response = this.queryDetail(id);
        SubFinishVO finishVO = (SubFinishVO)((Object)response.getData());
        finishVO.setFinishDetail(finishVO.getFinishDetailList());
        finishVO.setPaidMoney(ComputeUtil.nullToZero((BigDecimal)finishVO.getPaidMoney()));
        finishVO.setUnPaidMoney(ComputeUtil.nullToZero((BigDecimal)finishVO.getUnPaidMoney()));
        JSONObject vo = (JSONObject)JSONObject.toJSON((Object)((Object)finishVO));
        Long contractId = finishVO.getContractId();
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(contractId));
        vo.put("contractId", (Object)contractEntity);
        json.put("Finish", (Object)vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubFinishVO>> queryList(@RequestBody QueryParam param) {
        return this.finishService.queryListVOs(param);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubFinishVO> vos) {
        return this.finishService.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubFinishRecordVO> queryDetailRecord(Long id) {
        SubFinishRecordVO vo = this.finishService.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetailAdd"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubFinishVO> queryDetailAdd(Long contractId) {
        SubFinishVO vo = this.finishService.queryDetailAdd(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u67e5\u8be2\u5408\u540c\u8f6c\u5316\u4e3a\u5b8c\u5de5\u7ed3\u7b97\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SubFinishVO> list = this.finishService.queryExportList(queryParam);
        HashMap<String, List<SubFinishVO>> beans = new HashMap<String, List<SubFinishVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sub-finish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="settleTaxMny") BigDecimal settleTaxMny, @RequestParam(value="contractTaxMny") BigDecimal contractTaxMny, @RequestParam(value="orgId") Long orgId) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.finishService.checkParams(purchaseType, settleTaxMny, contractTaxMny, orgId));
    }
}

