package com.ejianc.business.labprice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labprice.bean.LaborQuoteDetailEntity;
/**
 * 劳务询价报价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_labprice_labor_quote")
public class LaborQuoteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 0-自由态，1-已提交
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="quote_time")
    private Date quoteTime; // 报价时间
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价单id
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 纳税人识别号
    @TableField(value="legal")
    private String legal; // 联系人
    @TableField(value="telephone")
    private String telephone; // 联系电话
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 投标总金额
    @TableField(value="total_mny_no_tax")
    private BigDecimal totalMnyNoTax; // 投标总金额(无税)
    @TableField(value="quote_memo")
    private String quoteMemo; // 备注
    @TableField(value="quote_phone")
    private String quotePhone; // 报价手机号（登录的手机号）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="laborQuoteDetailService", pidName = "quoteId")
    private List<LaborQuoteDetailEntity> laborQuoteDetailList = new ArrayList<>(); // 劳务询价-报价详情
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getTotalMnyNoTax() {
        return totalMnyNoTax;
    }

    public void setTotalMnyNoTax(BigDecimal totalMnyNoTax) {
        this.totalMnyNoTax = totalMnyNoTax;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public String getQuotePhone() {
        return quotePhone;
    }

    public void setQuotePhone(String quotePhone) {
        this.quotePhone = quotePhone;
    }
    

    public List<LaborQuoteDetailEntity> getLaborQuoteDetailList() {
        return laborQuoteDetailList;
    }

    public void setLaborQuoteDetailList(List<LaborQuoteDetailEntity> laborQuoteDetailList) {
        this.laborQuoteDetailList = laborQuoteDetailList;
    }
}
