package com.ejianc.business.labprice.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.labprice.bean.LaborPicketageEntity;
import com.ejianc.business.labprice.service.impl.LaborPicketageServiceImpl;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.service.impl.PicketageServiceImpl;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labprice.bean.LaborInquiryEntity;
import com.ejianc.business.labprice.service.ILaborInquiryService;
import com.ejianc.business.labprice.vo.LaborInquiryVO;

/**
 * 劳务询价
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("laborInquiry")
public class LaborInquiryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZYDX_LABOR_INQUIRY";//此处需要根据实际修改

    @Autowired
    private ILaborInquiryService service;

    @Autowired
    private LaborPicketageServiceImpl picketageService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ArchivesUtil archivesUtil;

//    @Autowired
//    private IMaterialSettlementApi materialSettlementApi;

    @Autowired
    private IEmployeeApi employeeApi;

    //流程标识1询价2开标
    private static final String PARAM_BID_PROCESS = "P-k8181N67";

    @Autowired
    private IParamConfigApi paramConfigApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborInquiryVO> saveOrUpdate(@RequestBody LaborInquiryVO saveOrUpdateVO) {
    	LaborInquiryEntity entity = BeanMapper.map(saveOrUpdateVO, LaborInquiryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getBidProcess() == null){
            //放置流程标识1询价2开标
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_BID_PROCESS);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                entity.setBidProcess(Integer.valueOf(valueData));
            }
        }
        //默认开标状态
        if(entity.getBidOpenState() == null){
            entity.setBidOpenState(0);
        }
    	service.saveOrUpdate(entity, false);
    	LaborInquiryVO vo = BeanMapper.map(entity, LaborInquiryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborInquiryVO> queryDetail(Long id) {
    	LaborInquiryEntity entity = service.selectById(id);
    	LaborInquiryVO vo = BeanMapper.map(entity, LaborInquiryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 截止报价，修改供应商
     * @param updateVo
     * @return
     */
    @RequestMapping(value = "/updateInquiry", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborInquiryVO> updateInquiry(@RequestBody LaborInquiryVO updateVo){
        LambdaQueryWrapper<LaborPicketageEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(LaborPicketageEntity::getInquiryId,updateVo.getId());
        List<LaborPicketageEntity> list = picketageService.list(queryWrapper);
        if(list.size()>0){
            return CommonResponse.error("修改失败，当前单据已定标！");
        }

        LaborInquiryVO vo = service.updateInquiry(updateVo);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborInquiryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LaborInquiryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LaborInquiryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborInquiryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(param.getParams().containsKey("inquiryState")){
            Integer inquiryState = Integer.parseInt(param.getParams().get("inquiryState").getValue().toString());
            //筛选条件为报价中时，同时查询报价中、已截止但还未到截止报价时间的
            if(InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.GT,new Date()));
            }
            //判断当前筛选条件询价状态是已截止的，同时查询询价状态为报价中但截止报价时间小于当前时间的
            if(InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            }
            //筛选条件为已定标，同时查询已定标和已签订
            if(InquiryStateEnum.WIN_STATE.getCode() == inquiryState){
                param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.WIN_STATE.getCode(),InquiryStateEnum.SIGN_STATE.getCode())));
            }
        }

        IPage<LaborInquiryEntity> page = service.queryPage(param,false);
        IPage<LaborInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LaborInquiryVO> vos = BeanMapper.mapList(page.getRecords(), LaborInquiryVO.class);
        for (LaborInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            //报价中但已超时的询价申请，需要显示为已截止
            if(InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0){
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            //已截止并且截止时间大于当前时间，显示为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0){
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
            //询价状态为已签订的，显示为已定标
            if(InquiryStateEnum.SIGN_STATE.getCode().equals(vo.getInquiryState())){
                vo.setInquiryStateName(InquiryStateEnum.WIN_STATE.getDescription());
            }
        }
        pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborInquiryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborInquiry-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborInquiryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborInquiryVO>> refLaborInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
            QueryParam param = new QueryParam();
            param.setPageSize(pageSize);
            param.setPageIndex(pageNumber);
            param.setSearchObject(searchObject);
            if (StringUtils.isNotBlank(searchText)) {
                param.setSearchText(searchText);
                /** 模糊搜索配置字段示例 */
                List<String> fuzzyFields = param.getFuzzyFields();
                fuzzyFields.add("purchaseSubject");
                fuzzyFields.add("projectName");
                fuzzyFields.add("orgName");
            }
            /** 租户隔离 */
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            if(StringUtils.isNotEmpty(condition)){
                /** 处理condition */
                JSONObject _con = JSONObject.parseObject(condition);
            }
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            param.getParams().put("inquiryState",new Parameter(QueryParam.IN,Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(),InquiryStateEnum.EXPIRATION_STATE.getCode())));
            param.getParams().put("quoteEndDate",new Parameter(QueryParam.LT,new Date()));
            param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            orderMap.put("inquiry_date", "desc");
            param.getOrderMap().putAll(orderMap);
            IPage<LaborInquiryEntity> page = service.queryPage(param,false);
            IPage<LaborInquiryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<LaborInquiryVO> vos = BeanMapper.mapList(page.getRecords(), LaborInquiryVO.class);
            for (LaborInquiryVO vo : vos) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            pageData.setRecords(vos);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }


    @ApiOperation("开标")
    @RequestMapping(value = "/openBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborInquiryVO> openBid(@RequestParam Long id) {
        LambdaUpdateWrapper<LaborInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(LaborInquiryEntity::getId, id);
        updateWrapper.set(LaborInquiryEntity::getBidOpenState, 1);
        service.update(updateWrapper);
        return CommonResponse.success("开标成功！");
    }
}
