package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.market.bean.PermitSafeDetailEntity;
import com.ejianc.business.market.bean.PermitAirDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 有限空间作业许可证
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_market_space_permit")
public class SpacePermitEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单号
    @TableField(value="begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date beginDate; // 开工时间
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endDate; // 结束时间
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 验收人
    @TableField(value="employee_name")
    private String employeeName; // 验收人
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="apply_team")
    private String applyTeam; // 申请班组
    @TableField(value="apply_people")
    private String applyPeople; // 申请人员(现场负责人员)
    @TableField(value="team_phone")
    private String teamPhone; // 班组联系电话
    @TableField(value="oversee_people")
    private String overseePeople; // 监护人员
    @TableField(value="oversee_phone")
    private String overseePhone; // 监护人电话
    @TableField(value="work_people")
    private String workPeople; // 作业人员
    @TableField(value="manager_phone")
    private String managerPhone; // 项目负责人或安全员联系电话
    @TableField(value="memo")
    private String memo; // 作业区域、内容
    @TableField(value="remark")
    private String remark; // 作业主要危险因素
    @TableField(value="employee_memo")
    private String employeeMemo; // 验收人(现场负责人)意见
    @TableField(value="employee_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date employeeDate; // 验收日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="permitSafeDetailService")
    private List<PermitSafeDetailEntity> permitSafeDetailList = new ArrayList<>(); // 有限空间作业许可证-作业安全措施确认
    @TableField(exist=false)
    @SubEntity(serviceName="permitAirDetailService")
    private List<PermitAirDetailEntity> permitAirDetailList = new ArrayList<>(); // 有限空间作业许可证-作业人员气体检测
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getApplyTeam() {
        return applyTeam;
    }

    public void setApplyTeam(String applyTeam) {
        this.applyTeam = applyTeam;
    }
    public String getApplyPeople() {
        return applyPeople;
    }

    public void setApplyPeople(String applyPeople) {
        this.applyPeople = applyPeople;
    }
    public String getTeamPhone() {
        return teamPhone;
    }

    public void setTeamPhone(String teamPhone) {
        this.teamPhone = teamPhone;
    }
    public String getOverseePeople() {
        return overseePeople;
    }

    public void setOverseePeople(String overseePeople) {
        this.overseePeople = overseePeople;
    }
    public String getOverseePhone() {
        return overseePhone;
    }

    public void setOverseePhone(String overseePhone) {
        this.overseePhone = overseePhone;
    }
    public String getWorkPeople() {
        return workPeople;
    }

    public void setWorkPeople(String workPeople) {
        this.workPeople = workPeople;
    }
    public String getManagerPhone() {
        return managerPhone;
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getEmployeeMemo() {
        return employeeMemo;
    }

    public void setEmployeeMemo(String employeeMemo) {
        this.employeeMemo = employeeMemo;
    }
    public Date getEmployeeDate() {
        return employeeDate;
    }

    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }
    

    public List<PermitSafeDetailEntity> getPermitSafeDetailList() {
        return permitSafeDetailList;
    }

    public void setPermitSafeDetailList(List<PermitSafeDetailEntity> permitSafeDetailList) {
        this.permitSafeDetailList = permitSafeDetailList;
    }

    public List<PermitAirDetailEntity> getPermitAirDetailList() {
        return permitAirDetailList;
    }

    public void setPermitAirDetailList(List<PermitAirDetailEntity> permitAirDetailList) {
        this.permitAirDetailList = permitAirDetailList;
    }
}
