package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.ContractRecordEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.mapper.ContractChangeMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IContractRecordService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.ContractChangeVO;
import com.ejianc.business.material.vo.ContractDetailChangeVO;
import com.ejianc.business.material.vo.ContractOtherCostChangeVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description: 物资合同变更数据处理服务实现类
 * @date 2020/6/12 11:49
 */
@Service("contractChangeService")
public class ContractChangeServiceImpl extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity> implements IContractChangeService {

    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractRecordService contractRecordService;




    @Override
    public ContractChangeVO save(ContractChangeVO contractChangeVO) {
        MaterialContractEntity contract = materialContractService.selectById(contractChangeVO.getMaterialContractId());
        ContractChangeEntity saveEntity = null;
        ContractChangeEntity dbEntity = null;
        UserContext userContext = sessionManager.getUserContext();
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, BigDecimal.ROUND_HALF_UP);

        if (null == contractChangeVO.getId() || contractChangeService.getById(contractChangeVO.getId())==null) {
            //新增
            //设置变更版本
            contractChangeVO.setChangeVersion(contract.getChangeVersion() + 1);
            //contractChangeVO.setId(IdWorker.getId());
            //设置初始版本合同金额(不含税)
            contractChangeVO.setBaseMoney(contract.getBaseMoney());
            //设置初始版本合同金额（含税）
            contractChangeVO.setBaseTaxMoney(contract.getBaseTaxMoney());
            //设置变更前合同金额（不含税）
            contractChangeVO.setBeforeChangeMny(contract.getAmountWithoutTax());
            //设置变更前合同金额（含税）
            contractChangeVO.setBeforeChangeTaxMny(contract.getAmountWithTax());
            //设置变跟前合同名称
            contractChangeVO.setBeforeContractName(contract.getName());
            //设置单据审批状态-自由态
            contractChangeVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //设置变更日期
            contractChangeVO.setChangeDate(new Date());
            contractChangeVO.setCreateUserName(userContext.getUserName());

            //合同变更状态-变更中
            contract.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING);
            //变更表Id
            contract.setChangeId(contractChangeVO.getId());
            //变更审批状态
            contract.setChangeBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        } else {
            dbEntity = super.selectById(contractChangeVO.getId());
        }

        //对新增行进行设置
        if (CollectionUtils.isNotEmpty(contractChangeVO.getMaterialDetailList())) {
            contractChangeVO.getMaterialDetailList().stream().filter(detail -> null == detail.getChangeId())
                    .forEach(detail -> {
                        detail.setId(null);
                        detail.setMaterialContractId(contract.getId());
                        detail.setChangeId(contractChangeVO.getId());
                    });

            totalAmountWith = totalAmountWith.add(contractChangeVO.getMaterialDetailList()
                    .stream().filter(detail -> !ContractDetailChangeVO.CHANGE_TYPE_DEL.equals(detail.getChangeType()) && (null != detail.getTotalAmount()))
                    .map(ContractDetailChangeVO::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(contractChangeVO.getOtherCostList())) {
            contractChangeVO.getOtherCostList().stream().filter(cost -> null == cost.getChangeId())
                    .forEach(cost -> {
                        //cost.setId(null);
                        cost.setMaterialContractId(contract.getId());
                        cost.setChangeId(contractChangeVO.getId());
                    });
            totalAmountWith = totalAmountWith.add(contractChangeVO.getOtherCostList().stream()
                    .filter(cost -> null != cost.getCostAmount())
                    .map(ContractOtherCostChangeVO::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(contractChangeVO.getContractItemList())) {
            contractChangeVO.getContractItemList().stream().filter(item -> null == item.getChangeId())
                    .forEach(item -> {
                        item.setId(null);
                        item.setMaterialContractId(contract.getId());
                        item.setChangeId(contractChangeVO.getId());
                    });
        }

        //都为空,则是没子表,手动录入的,不需要在合计
       /* if (CollectionUtils.isNotEmpty(contractChangeVO.getMaterialDetailList()) || CollectionUtils.isNotEmpty(contractChangeVO.getOtherCostList())) {
            contractChangeVO.setAmountWithTax(totalAmountWith);
            contractChangeVO.setAmountWithoutTax(totalAmountWith.divide(new BigDecimal(1 + contractChangeVO.getTaxRate() / 100), 8, BigDecimal.ROUND_HALF_UP));
            contractChangeVO.setTaxFee(contractChangeVO.getAmountWithTax().subtract(contractChangeVO.getAmountWithoutTax()).setScale(8, BigDecimal.ROUND_HALF_UP));
        }
*/
        //保存-更新
        saveEntity = BeanMapper.map(contractChangeVO, ContractChangeEntity.class);
        if (null != dbEntity) {
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            //修改人名称
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        super.saveOrUpdate(saveEntity, false);

        //修改合同对应字段

        //合同变更中金额(不含税)
        contract.setChangingMny(contractChangeVO.getAmountWithoutTax());
        //合同变更中金额（含税）
        contract.setChangingTaxMny(contractChangeVO.getAmountWithTax());
        //变更编码
        contract.setChangeCode(saveEntity.getCode());

        materialContractService.saveOrUpdate(contract, false);

        return BeanMapper.map(saveEntity, ContractChangeVO.class);
    }



    @Override
    public void deleteById(Long id, boolean b) {
        ContractChangeEntity e = super.selectById(id);
        if (
                !BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState())
                && !BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())

        ) {
            throw new BusinessException("删除失败，只能删除自由态/审批驳回的变更数据！");
        }
        Integer changeState = MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter(QueryParam.EQ, e.getMaterialContractId()));
        List<ContractRecordEntity> changeRecords = contractRecordService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(changeRecords)) {
            changeState = MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGED;
        }

        //合同先关字段还原
        MaterialContractEntity contract = materialContractService.selectById(e.getMaterialContractId());
        contract.setChangeBillState(null);
        contract.setChangeState(changeState);
        contract.setChangingMny(null);
        contract.setChangingTaxMny(null);
        contract.setChangeId(null);
        contract.setChangeCode(null);

        materialContractService.saveOrUpdate(contract, false);
        super.removeById(id, false);
    }
}
