/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.bean.OtherSettleOtherEntity;
import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleDetailService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleOtherVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.other.vo.SettleHistoryVo;
import com.ejianc.business.utils.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettleService")
public class OtherSettleServiceImpl
extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity>
implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    private static final String CHECK_PARAM_CODE = "P-NB2T3930";
    private static final String OTHER_SETTLE_BILL_CODE = "OTHER_SETTLE";
    private static final String OTHER_SETTLE_DETAIL_BILL_CODE = "OTHER_SETTLE_DETAIL";
    private static final String OTHER_SETTLE_OTHER_BILL_CODE = "OTHER_SETTLE_OTHER";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherSettleDetailService otherSettleDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        OtherContractEntity otherContractEntity;
        int num;
        LambdaQueryWrapper lambdaQuery;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            operateType = "edit";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        } else {
            operateType = "add";
            lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            num = super.count((Wrapper)lambdaQuery);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
        }
        if ((otherContractEntity = (OtherContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))).getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b8c\u5de5\u7ed3\u7b97!");
        }
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), OtherSettleEntity.class));
            operateType = "edit";
        } else {
            entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), OtherSettleEntity.class));
            operateType = "add";
        }
        List entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd(entity.getSettleTaxMny(), entity.getSumSettleTaxMny()));
        entity.setRelationFlag(this.getRelationFlag(saveorUpdateVO));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)((Object)this.queryDetail(entity.getId())));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)super.selectById((Serializable)id));
        OtherSettleVO vo = (OtherSettleVO)((Object)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class));
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractStatus(contractEntity.getContractStatus());
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)id);
        Long orgId = InvocationInfoProxy.getOrgId();
        if (!"1".equals(contractEntity.getDependOnProject())) {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
            if (orgResp.isSuccess()) {
                List orgIds = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                lambdaQuery.in(OtherSettleEntity::getOrgId, orgIds);
            }
        } else {
            lambdaQuery.eq(OtherSettleEntity::getOrgId, (Object)orgId);
        }
        lambdaQuery.orderByDesc(BaseEntity::getCreateTime);
        List listAllState = super.list((Wrapper)lambdaQuery);
        lambdaQuery.in(OtherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal settleTaxMny = BigDecimal.ZERO;
            for (OtherSettleEntity otherSettleEntity : list) {
                settleTaxMny = ComputeUtil.safeAdd(settleTaxMny, otherSettleEntity.getSettleTaxMny());
                BigDecimal ratio = ComputeUtil.safeDiv(otherSettleEntity.getSettleTaxMny(), contractEntity.getContractTaxMny());
                otherSettleEntity.setSumSettleRate(ComputeUtil.safeMultiply(ratio, new BigDecimal(100)));
            }
            BigDecimal safeDiv = MathUtil.safeDiv(settleTaxMny, contractEntity.getContractTaxMny());
            vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
            vo.setSumSettleTaxMny(settleTaxMny);
        } else {
            vo.setSumSettleRate(BigDecimal.ZERO);
            vo.setSumSettleTaxMny(BigDecimal.ZERO);
        }
        vo.setSettleRecord(BeanMapper.mapList((Iterable)listAllState, OtherSettleVO.class));
        return vo;
    }

    @Override
    public CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)((OtherSettleMapper)this.baseMapper).selectById(otherSettleVO.getId()));
        if (ListUtil.isNotEmpty(otherSettleVO.getDetailVos())) {
            List purchaseSettleDetail = BeanMapper.mapList(otherSettleVO.getDetailVos(), OtherSettleDetailEntity.class);
            entity.setDetailVos(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty(otherSettleVO.getOtherVos())) {
            List purchaseSettleFee = BeanMapper.mapList(otherSettleVO.getOtherVos(), OtherSettleOtherEntity.class);
            entity.setOtherVos(purchaseSettleFee);
        }
        String relationFlag = this.getRelationFlag(otherSettleVO);
        entity.setRelationFlag(relationFlag);
        super.saveOrUpdate((Object)entity, false);
        Integer billState = entity.getBillState();
        if (relationFlag.equals("1")) {
            if (billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                this.processCost(entity);
            } else {
                this.delCost(entity.getId());
            }
        } else {
            this.delCost(entity.getId());
        }
        return CommonResponse.success((Object)((Object)this.queryDetail(entity.getId())));
    }

    public String getRelationFlag(OtherSettleVO otherSettleVO) {
        List<OtherSettleDetailVO> detailVos = otherSettleVO.getDetailVos();
        List<OtherSettleOtherVO> otherVos = otherSettleVO.getOtherVos();
        String relationFlag = "1";
        for (OtherSettleDetailVO detailVO : detailVos) {
            if (detailVO.getSubjectId() != null && detailVO.getSubjectId() > 0L) continue;
            relationFlag = "0";
        }
        for (OtherSettleOtherVO otherVO : otherVos) {
            if (otherVO.getOtherSubjectId() != null && otherVO.getOtherSubjectId() > 0L) continue;
            relationFlag = "0";
        }
        return relationFlag;
    }

    @Override
    public void processCost(OtherSettleEntity entity) {
    }

    @Override
    public void delCost(Long id) {
    }

    @Override
    public List<OtherSettleDetailVO> settlementExcelDownload(OtherSettleVO vo) {
        ArrayList<OtherSettleDetailVO> list = new ArrayList<OtherSettleDetailVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List entityList = this.queryList(queryParam, false);
        for (OtherSettleEntity rentSettlementEntity : entityList) {
            queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter("eq", (Object)rentSettlementEntity.getId()));
            List detailEntityList = this.otherSettleDetailService.queryList(queryParam, false);
            if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
            List listTemp = BeanMapper.mapList((Iterable)detailEntityList, OtherSettleDetailVO.class);
            for (int i = 0; i < listTemp.size(); ++i) {
                OtherSettleDetailVO otherSettleDetailVO = (OtherSettleDetailVO)((Object)listTemp.get(i));
                if ("1".equals(otherSettleDetailVO.getSourceType())) {
                    otherSettleDetailVO.setSourceTypeName("\u5408\u540c\u5916");
                } else if ("0".equals(otherSettleDetailVO.getSourceType())) {
                    otherSettleDetailVO.setSourceTypeName("\u5408\u540c\u5185");
                } else {
                    otherSettleDetailVO.setSourceTypeName(null);
                }
                otherSettleDetailVO.setSettlementCode(rentSettlementEntity.getBillCode());
            }
            list.addAll(listTemp);
        }
        return list;
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper query = OtherSettleServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(settle_tax_mny) as totalSettleAmount"});
        Map amount = super.getMap((Wrapper)query);
        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }
}

