package com.ejianc.business.material.service;

import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 量价分离查看控制
 * @date 2022/6/2
 */
@Service
public class ViewLimitService {

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IRoleApi roleApi;

    //是否可以查看单价和金额
    private static final String PARAM_VIEW_CODE = "P-1k714N29";


    /**
     * @description: 是否可以查看单价和金额
     * @return: java.lang.Boolean
     * @author songlx
     * @date: 2022/6/2
     */
    public Boolean noView() {
        return this.getCanFlagByRoleAndParam(PARAM_VIEW_CODE);
    }


    public Boolean getCanFlagByRoleAndParam(String paramCode) {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(paramCode);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valueData.contains(roleVO.getCode()))
                            return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }
}
