/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.EngdepartRespcostDetailVO;
import com.ejianc.business.cost.vo.EngdepartRespcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"engdepartRespcost"})
public class EngdepartRespcostController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxEngdepartRespcost";
    @Autowired
    private IEngdepartRespcostService service;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> saveOrUpdate(@RequestBody EngdepartRespcostVO saveOrUpdateVO) {
        PreBidCostCalcEntity preBidCostCalcEntity;
        EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), EngdepartRespcostEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((preBidCostCalcEntity = this.preBidCostCalcService.queryDataByProjectId(saveOrUpdateVO.getProjectId())) == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8be5\u9879\u76ee\u6807\u524d\u6d4b\u7b97\u6570\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6807\u524d\u6d4b\u7b97");
        }
        BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal() != null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);
        String projectProperty = "\u7236\u9879\u76ee";
        ArrayList<Long> pIds = new ArrayList<Long>();
        pIds.add(saveOrUpdateVO.getProjectId());
        CommonResponse pvos = this.projectApi.queryProjectByIds(pIds);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (pvos.isSuccess() && pvos.getData() != null && ((List)pvos.getData()).size() > 0) {
            ProjectRegisterVO pvo = (ProjectRegisterVO)((List)pvos.getData()).get(0);
            if (pvo.getParentId() != null) {
                projectProperty = "\u5b50\u9879\u76ee";
                CommonResponse listResponse = this.projectApi.queryProjectByPid(pvo.getParentId());
                if (listResponse.isSuccess() && listResponse.getData() != null && ((List)listResponse.getData()).size() > 0) {
                    for (ProjectRegisterVO vo : (List)listResponse.getData()) {
                        projectIds.add(vo.getId());
                    }
                }
            } else {
                projectIds.add(saveOrUpdateVO.getProjectId());
            }
        }
        if (entity.getEngdepartRespcostDetailList() != null && entity.getEngdepartRespcostDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getEngdepartRespcostDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setRespcostId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getEngdepartRespcostDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        EngdepartRespcostVO vo = (EngdepartRespcostVO)((Object)BeanMapper.map((Object)((Object)entity), EngdepartRespcostVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getEngdepartRespcostDetailList())) {
            EngdepartRespcostController.sortIntMethod(vo.getEngdepartRespcostDetailList());
            List<EngdepartRespcostDetailVO> detailVOS = EngdepartRespcostController.createTreeData(vo.getEngdepartRespcostDetailList());
            vo.setEngdepartRespcostDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> queryDetail(Long id) {
        EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)this.service.selectById(id));
        EngdepartRespcostVO vo = (EngdepartRespcostVO)((Object)BeanMapper.map((Object)((Object)entity), EngdepartRespcostVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getEngdepartRespcostDetailList())) {
            EngdepartRespcostController.sortIntMethod(vo.getEngdepartRespcostDetailList());
            List<EngdepartRespcostDetailVO> detailVOS = EngdepartRespcostController.createTreeData(vo.getEngdepartRespcostDetailList());
            vo.setEngdepartRespcostDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> queryDetailByProjectId(Long projectId) {
        EngdepartRespcostVO vo = this.service.queryDetailByProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngdepartRespcostVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EngdepartRespcostVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngdepartRespcostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EngdepartRespcost-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEngdepartRespcostData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EngdepartRespcostVO>> refEngdepartRespcostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"excodeProjectTargetcost") != null) {
            param.getParams().put("excodeProjectTargetcost", new Parameter("sql", (Object)" (id not in (select t.respcost_id from ejc_zypms_project_targetcost t where t.dr = 0 and t.respcost_id is not null))"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngdepartRespcostVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private static void sortIntMethod(List<EngdepartRespcostDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                EngdepartRespcostDetailVO o1Detail = (EngdepartRespcostDetailVO)((Object)objectMapper.convertValue(o1, EngdepartRespcostDetailVO.class));
                EngdepartRespcostDetailVO o2Detail = (EngdepartRespcostDetailVO)((Object)objectMapper.convertValue(o2, EngdepartRespcostDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<EngdepartRespcostDetailVO> createTreeData(List<EngdepartRespcostDetailVO> list) {
        ArrayList<EngdepartRespcostDetailVO> resp = new ArrayList<EngdepartRespcostDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, EngdepartRespcostDetailVO> listMap = new HashMap<String, EngdepartRespcostDetailVO>();
        for (EngdepartRespcostDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            EngdepartRespcostDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            EngdepartRespcostDetailVO parent = (EngdepartRespcostDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<EngdepartRespcostDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<EngdepartRespcostDetailVO> children = new ArrayList<EngdepartRespcostDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((EngdepartRespcostDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/checkBillParam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody EngdepartRespcostVO vo) {
        JSONArray list = new JSONArray();
        return CommonResponse.success((Object)list);
    }

    @RequestMapping(value={"/queryDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDataByProjectId(Long projectId) {
        JSONObject data = this.service.queryDataByProjectId(projectId);
        return CommonResponse.success((Object)data);
    }
}

