package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.PrjcontractCostsDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目合同造价表
 * 
 * @author generator
 * 
 */
public class PrjcontractCostsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String projectTargetcostIds; // 项目目标成本
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 组织ID
    private String orgName; // 所属单位名称
    private Long prebidId; // 标前测算ID
    private BigDecimal prebidCost; // 标前测算金额
    private String pubUnitName; // 发包单位名称
    private String contractUnitName; // 承包单位名称
    private BigDecimal contractTaxMny; // 含税合同额
    private BigDecimal contractMny; // 不含税合同额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 项目开工时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 项目完工时间
    private String address; // 施工地点
    private Long establishmentOrgId; // 编制单位ID
    private String establishmentOrgName; // 编制单位名称
    private Long establishmentUserId; // 编制人ID
    private String establishmentUserName; // 编制人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制日期
    private BigDecimal constructionCost; // 造价金额
    private BigDecimal prjcostTotal; // 全部项目直接成本
    private BigDecimal prjcostGrossProfit; // 项目毛利润
    private String prjcostRate; // 项目毛利率
    private BigDecimal prjsaleCost; // 工程部销售费用
    private BigDecimal manageCost; // 公司管理、销售费用等
    private BigDecimal taxCost; // 税金及附加
    private BigDecimal prjcostProfit; // 项目利润
    private String remark; // 备注
    
    private List<PrjcontractCostsDetailVO> prjcontractCostsDetailList = new ArrayList<>(); // 项目合同造价表明细

    public BigDecimal getConstructionCost() {
        return constructionCost;
    }

    public void setConstructionCost(BigDecimal constructionCost) {
        this.constructionCost = constructionCost;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="zydx-preBidCostCalc")
    public Long getPrebidId() {
        return prebidId;
    }

    @ReferDeserialTransfer
    public void setPrebidId(Long prebidId) {
        this.prebidId = prebidId;
    }
    public BigDecimal getPrebidCost() {
        return prebidCost;
    }

    public void setPrebidCost(BigDecimal prebidCost) {
        this.prebidCost = prebidCost;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    
    public String getPubUnitName() {
		return pubUnitName;
	}

	public void setPubUnitName(String pubUnitName) {
		this.pubUnitName = pubUnitName;
	}

	public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public BigDecimal getPrjcostTotal() {
        return prjcostTotal;
    }

    public void setPrjcostTotal(BigDecimal prjcostTotal) {
        this.prjcostTotal = prjcostTotal;
    }
    public BigDecimal getPrjcostGrossProfit() {
        return prjcostGrossProfit;
    }

    public void setPrjcostGrossProfit(BigDecimal prjcostGrossProfit) {
        this.prjcostGrossProfit = prjcostGrossProfit;
    }
    public String getPrjcostRate() {
        return prjcostRate;
    }

    public void setPrjcostRate(String prjcostRate) {
        this.prjcostRate = prjcostRate;
    }
    public BigDecimal getPrjsaleCost() {
        return prjsaleCost;
    }

    public void setPrjsaleCost(BigDecimal prjsaleCost) {
        this.prjsaleCost = prjsaleCost;
    }
    public BigDecimal getManageCost() {
        return manageCost;
    }

    public void setManageCost(BigDecimal manageCost) {
        this.manageCost = manageCost;
    }
    public BigDecimal getTaxCost() {
        return taxCost;
    }

    public void setTaxCost(BigDecimal taxCost) {
        this.taxCost = taxCost;
    }
    public BigDecimal getPrjcostProfit() {
        return prjcostProfit;
    }

    public void setPrjcostProfit(BigDecimal prjcostProfit) {
        this.prjcostProfit = prjcostProfit;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
     public List<PrjcontractCostsDetailVO> getPrjcontractCostsDetailList() {
        return prjcontractCostsDetailList;
     }

     public void setPrjcontractCostsDetailList(List<PrjcontractCostsDetailVO> prjcontractCostsDetailList) {
        this.prjcontractCostsDetailList = prjcontractCostsDetailList;
     }

    public String getProjectTargetcostIds() {
        return projectTargetcostIds;
    }

    public void setProjectTargetcostIds(String projectTargetcostIds) {
        this.projectTargetcostIds = projectTargetcostIds;
    }
}
