package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.material.bean.InstallDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 安装验收
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_material_install")
public class InstallEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 出库单号
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 验收日期
    @TableField(value="out_store_id")
    private Long outStoreId; // 出库单id
    @TableField(value="out_store_name")
    private String outStoreName; // 出库单名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 验收人
    @TableField(value="employee_name")
    private String employeeName; // 验收人
    @TableField(value="project_name")
    private String projectName; // 出库项目名称
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="join_people")
    private String joinPeople; // 参与人
    @TableField(value="pub_unit")
    private Long pubUnit; // 发包单位
    @TableField(value="pub_unit_name")
    private String pubUnitName; // 发包单位名称
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 承包单位
    @TableField(value="contractor_unit_name")
    private String contractorUnitName; // 承包单位名字
    @TableField(value="project_manager")
    private Long projectManager; // 项目经理
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="memo")
    private String memo; // 验收内容
    @TableField(value="remark")
    private String remark; // 验收结论
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="installDetailService")
    private List<InstallDetailEntity> installDetailList = new ArrayList<>(); // 安装验收-详情
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getJoinPeople() {
        return joinPeople;
    }

    public void setJoinPeople(String joinPeople) {
        this.joinPeople = joinPeople;
    }
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<InstallDetailEntity> getInstallDetailList() {
        return installDetailList;
    }

    public void setInstallDetailList(List<InstallDetailEntity> installDetailList) {
        this.installDetailList = installDetailList;
    }
}
