package com.ejianc.business.utils;

import java.math.BigDecimal;

/**
 * @author beibeiup
 */
public class BigDecimalUtils {

    public final static int DEFAULT_SCALE = 8;

    public final static int DEFAULT_ROUND_HALF = BigDecimal.ROUND_HALF_UP;

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        } else {
            return decimal1.divide(decimal2, DEFAULT_SCALE, DEFAULT_ROUND_HALF);
        }
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            return decimal2;
        }
        if (decimal2 == null) {
            return decimal1;
        }
        return decimal1.add(decimal2);
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.multiply(decimal2).setScale(DEFAULT_SCALE, DEFAULT_ROUND_HALF);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }
        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }
        return decimal1.subtract(decimal2);
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? src : src.setScale(2, DEFAULT_ROUND_HALF);
    }

    /**
     * 判断num是否为空 或者 零
     *
     * @param num
     * @return String
     */
    public static Boolean isEmpty(BigDecimal num) {
        return null == num || BigDecimal.ZERO.compareTo(num) == 0;
    }

    /**
     * 判断num是否 不等于null 并且不等于零
     *
     * @param num
     * @return String
     */
    public static Boolean isNotEmpty(BigDecimal num) {
        return !isEmpty(num);
    }
}

