/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.EngdepartRespcostDetailEntity;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostDetailEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.mapper.EngdepartRespcostMapper;
import com.ejianc.business.cost.service.IEngdepartRespcostDetailService;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.EngdepartRespcostDetailVO;
import com.ejianc.business.cost.vo.EngdepartRespcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engdepartRespcostService")
public class EngdepartRespcostServiceImpl
extends BaseServiceImpl<EngdepartRespcostMapper, EngdepartRespcostEntity>
implements IEngdepartRespcostService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEngdepartRespcostDetailService engdepartRespcostDetailService;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private ProjectUtils projectUtils;
    @Autowired
    private IProjectApi projectApi;
    private static final String BILL_CODE = "zydxEngdepartRespcost";

    @Override
    public void checkAmount(Long projectId, String projectProperty, BigDecimal targetcostTotal) {
        BigDecimal costTaxTotal;
        PreBidCostCalcEntity preBidCostCalcEntity = this.preBidCostCalcService.queryDataByProjectId(projectId);
        if (preBidCostCalcEntity == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8be5\u9879\u76ee\u6807\u524d\u6d4b\u7b97\u6570\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6807\u524d\u6d4b\u7b97");
        }
        BigDecimal bigDecimal = costTaxTotal = preBidCostCalcEntity.getCostTaxTotal() != null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);
        if ("\u5b50\u9879\u76ee".equals(projectProperty)) {
            List<Long> projectIds = this.projectUtils.getProjectList(projectId);
            projectIds.add(projectId);
            if (projectIds != null && projectIds.size() > 0) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.in((Object)"project_id", projectIds);
                List lsit = this.list((Wrapper)wrapper);
                if (lsit != null && lsit.size() > 0) {
                    BigDecimal all = targetcostTotal != null ? targetcostTotal : new BigDecimal(0);
                    for (EngdepartRespcostEntity vo : lsit) {
                        if (!vo.getId().equals(projectId)) {
                            BigDecimal respcostTotal = vo.getRespcostTotal() != null ? vo.getRespcostTotal() : new BigDecimal(0);
                            all = all.add(respcostTotal);
                            continue;
                        }
                        BigDecimal prjsaleCost = vo.getPrjsaleCost() != null ? vo.getPrjsaleCost() : new BigDecimal(0);
                        all = all.add(prjsaleCost);
                    }
                    if (all.compareTo(costTaxTotal) > 0) {
                        throw new BusinessException("\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\uff1a\u5b50\u9879\u76ee\u7d2f\u8ba1\u8d23\u4efb\u6210\u672c\u603b\u91d1\u989d\u3010" + all.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u6807\u524d\u6d4b\u7b97\u3010" + costTaxTotal.setScale(2, 4) + "\u3011");
                    }
                }
            }
        } else {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"project_id", (Object)projectId);
            List lsit = this.list((Wrapper)wrapper);
            if (lsit != null && lsit.size() > 0) {
                BigDecimal amont = targetcostTotal != null ? targetcostTotal : new BigDecimal(0);
                EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)lsit.get(0));
                BigDecimal prebidCost = entity.getPrebidCost() != null ? entity.getPrebidCost() : new BigDecimal(0);
                if ((amont = amont.add(prebidCost)).compareTo(costTaxTotal) > 0) {
                    throw new BusinessException("\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\uff1a\u8d23\u4efb\u6210\u672c\u603b\u91d1\u989d\u3010" + amont.setScale(2, 4) + "\u3011\u4e0d\u5f97\u8d85\u6807\u524d\u6d4b\u7b97\u3010" + costTaxTotal.setScale(2, 4) + "\u3011");
                }
            }
        }
    }

    @Override
    public void generate(ProjectTargetcostEntity targetcostEntity) {
        PreBidCostCalcEntity preBidCostCalcEntity = this.preBidCostCalcService.queryDataByProjectId(targetcostEntity.getProjectId());
        if (preBidCostCalcEntity == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8be5\u9879\u76ee\u6807\u524d\u6d4b\u7b97\u6570\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6807\u524d\u6d4b\u7b97");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prjcontract_targetcost_id", (Object)targetcostEntity.getId());
        EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)this.getOne((Wrapper)wrapper));
        if (entity != null) {
            entity.setRespcostTotal(targetcostEntity.getTargetcostTotal());
            entity.setPrebidCost(targetcostEntity.getTargetcostTotal());
            entity.setAllocateContractMny(targetcostEntity.getAllocateContractMny());
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"respcost_id", (Object)entity.getId());
            List dList = this.engdepartRespcostDetailService.list((Wrapper)detailWrapper);
            entity.setEngdepartRespcostDetailList(dList);
            HashMap<Long, EngdepartRespcostDetailEntity> exitMap = new HashMap<Long, EngdepartRespcostDetailEntity>();
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList())) {
                for (EngdepartRespcostDetailEntity engdepartRespcostDetailEntity : entity.getEngdepartRespcostDetailList()) {
                    exitMap.put(engdepartRespcostDetailEntity.getProjectTargetcostDetailId(), engdepartRespcostDetailEntity);
                }
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                ArrayList<EngdepartRespcostDetailEntity> engdepartRespcostDetailList = new ArrayList<EngdepartRespcostDetailEntity>();
                HashMap<String, Long> map = new HashMap<String, Long>();
                ArrayList<Long> exitIds = new ArrayList<Long>();
                for (ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()) {
                    EngdepartRespcostDetailEntity d;
                    exitIds.add(detail.getId());
                    if (exitMap.get(detail.getId()) != null) {
                        d = (EngdepartRespcostDetailEntity)((Object)exitMap.get(detail.getId()));
                        d.setCode(detail.getCode());
                        d.setAddState(detail.getAddState());
                        d.setCostAmount(detail.getCostAmount());
                        d.setAmount(detail.getAmount());
                        d.setFeeType(detail.getFeeType());
                        d.setSubjectCode(detail.getSubjectCode());
                        d.setSubjectId(detail.getSubjectId());
                        d.setSubjectName(detail.getSubjectName());
                        d.setRowState("edit");
                        map.put(detail.getCode(), d.getId());
                        engdepartRespcostDetailList.add(d);
                        continue;
                    }
                    d = new EngdepartRespcostDetailEntity();
                    d.setCode(detail.getCode());
                    d.setAddState(detail.getAddState());
                    d.setCostAmount(detail.getCostAmount());
                    d.setAmount(detail.getAmount());
                    d.setFeeType(detail.getFeeType());
                    d.setProjectTargetcostDetailId(detail.getId());
                    d.setSubjectCode(detail.getSubjectCode());
                    d.setSubjectId(detail.getSubjectId());
                    d.setSubjectName(detail.getSubjectName());
                    d.setRespcostId(entity.getId());
                    d.setRowState("add");
                    d.setId(IdWorker.getId());
                    map.put(detail.getCode(), d.getId());
                    engdepartRespcostDetailList.add(d);
                }
                if (engdepartRespcostDetailList != null && engdepartRespcostDetailList.size() > 0) {
                    engdepartRespcostDetailList.forEach(item -> {
                        if (item.getCode().indexOf(".") != -1) {
                            String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                            item.setPid((Long)map.get(code));
                        }
                    });
                }
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getEngdepartRespcostDetailList()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(exitIds)) {
                    for (EngdepartRespcostDetailEntity engdepartRespcostDetailEntity : entity.getEngdepartRespcostDetailList()) {
                        if (exitIds.contains(engdepartRespcostDetailEntity.getProjectTargetcostDetailId())) continue;
                        engdepartRespcostDetailEntity.setRowState("del");
                        engdepartRespcostDetailList.add(engdepartRespcostDetailEntity);
                    }
                }
                entity.setEngdepartRespcostDetailList(engdepartRespcostDetailList);
            }
        } else {
            entity = (EngdepartRespcostEntity)((Object)BeanMapper.map((Object)((Object)targetcostEntity), EngdepartRespcostEntity.class));
            Long id = IdWorker.getId();
            entity.setProjectTargetcostId(targetcostEntity.getId());
            entity.setRespcostTotal(targetcostEntity.getTargetcostTotal());
            entity.setPrebidCost(targetcostEntity.getTargetcostTotal());
            entity.setAllocateContractMny(targetcostEntity.getAllocateContractMny());
            entity.setBillState(0);
            entity.setEstablishmentDate(null);
            entity.setEstablishmentOrgId(null);
            entity.setEstablishmentOrgName(null);
            entity.setEstablishmentUserId(null);
            entity.setEstablishmentUserName(null);
            entity.setRemark(null);
            entity.setId(id);
            entity.setCreateTime(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setVersion(null);
            entity.setSyncEsFlag(null);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)entity), EngdepartRespcostVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(targetcostEntity.getProjectTargetcostDetailList())) {
                ArrayList<EngdepartRespcostDetailEntity> engdepartRespcostDetailList = new ArrayList<EngdepartRespcostDetailEntity>();
                HashMap<String, Long> map = new HashMap<String, Long>();
                for (ProjectTargetcostDetailEntity detail : targetcostEntity.getProjectTargetcostDetailList()) {
                    EngdepartRespcostDetailEntity d = new EngdepartRespcostDetailEntity();
                    d.setCode(detail.getCode());
                    d.setAddState(detail.getAddState());
                    d.setCostAmount(detail.getCostAmount());
                    d.setAmount(detail.getAmount());
                    d.setFeeType(detail.getFeeType());
                    d.setProjectTargetcostDetailId(detail.getId());
                    d.setSubjectCode(detail.getSubjectCode());
                    d.setSubjectId(detail.getSubjectId());
                    d.setSubjectName(detail.getSubjectName());
                    d.setRespcostId(id);
                    d.setRowState("add");
                    d.setId(IdWorker.getId());
                    map.put(detail.getCode(), d.getId());
                    engdepartRespcostDetailList.add(d);
                }
                if (engdepartRespcostDetailList != null && engdepartRespcostDetailList.size() > 0) {
                    engdepartRespcostDetailList.forEach(item -> {
                        if (item.getCode().indexOf(".") != -1) {
                            String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                            item.setPid((Long)map.get(code));
                        }
                    });
                }
                entity.setEngdepartRespcostDetailList(engdepartRespcostDetailList);
            }
        }
        this.saveOrUpdate((Object)entity, false);
    }

    @Override
    public JSONObject queryDataByProjectId(Long projectId) {
        JSONObject json = new JSONObject();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        CommonResponse listResponse = this.projectApi.queryProjectByPid(projectId);
        if (listResponse.isSuccess() && listResponse.getData() != null && ((List)listResponse.getData()).size() > 0) {
            for (ProjectRegisterVO vo : (List)listResponse.getData()) {
                projectIds.add(vo.getId());
            }
        } else {
            projectIds.add(projectId);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"project_id", projectIds);
        List list = this.list((Wrapper)wrapper);
        List data = new ArrayList();
        List<EngdepartRespcostDetailVO> detailList = new ArrayList<EngdepartRespcostDetailVO>();
        if (list != null && list.size() > 0) {
            data = BeanMapper.mapList((Iterable)list, EngdepartRespcostVO.class);
            HashMap<Long, List> detailMap = new HashMap<Long, List>();
            ArrayList<EngdepartRespcostDetailVO> allList = new ArrayList<EngdepartRespcostDetailVO>();
            ArrayList<Long> pids = new ArrayList<Long>();
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            HashMap<Long, Long> subjectIdMap = new HashMap<Long, Long>();
            HashMap subjectMap = new HashMap();
            for (EngdepartRespcostEntity entity : list) {
                QueryWrapper w = new QueryWrapper();
                w.eq((Object)"respcost_id", (Object)entity.getId());
                List dList = this.engdepartRespcostDetailService.list((Wrapper)w);
                if (dList == null || dList.size() <= 0) continue;
                detailMap.put(entity.getId(), dList);
                for (Object de : dList) {
                    List<EngdepartRespcostDetailVO> a;
                    idMap.put(de.getId(), IdWorker.getId());
                    EngdepartRespcostDetailVO vo = (EngdepartRespcostDetailVO)((Object)BeanMapper.map((Object)de, EngdepartRespcostDetailVO.class));
                    vo.setProjectId(entity.getProjectId());
                    vo.setProjectName(entity.getProjectName());
                    allList.add(vo);
                    if (((EngdepartRespcostDetailEntity)((Object)de)).getPid() != null && !pids.contains(((EngdepartRespcostDetailEntity)((Object)de)).getPid())) {
                        pids.add(((EngdepartRespcostDetailEntity)((Object)de)).getPid());
                    }
                    if (((EngdepartRespcostDetailEntity)((Object)de)).getAddState() != null && ((EngdepartRespcostDetailEntity)((Object)de)).getAddState().booleanValue()) {
                        detailList.add(vo);
                        continue;
                    }
                    subjectIdMap.put(((EngdepartRespcostDetailEntity)((Object)de)).getSubjectId(), IdWorker.getId());
                    if (subjectMap.get(((EngdepartRespcostDetailEntity)((Object)de)).getSubjectId()) != null) {
                        a = (List)subjectMap.get(((EngdepartRespcostDetailEntity)((Object)de)).getSubjectId());
                        a.add(vo);
                        subjectMap.put(((EngdepartRespcostDetailEntity)((Object)de)).getSubjectId(), a);
                        continue;
                    }
                    a = new ArrayList<EngdepartRespcostDetailVO>();
                    a.add(vo);
                    subjectMap.put(((EngdepartRespcostDetailEntity)((Object)de)).getSubjectId(), a);
                }
            }
            for (EngdepartRespcostDetailVO en : allList) {
                if (en.getSubjectId() == null) continue;
                idMap.put(en.getId(), (Long)subjectIdMap.get(en.getSubjectId()));
            }
            for (Long key : subjectMap.keySet()) {
                List subjectList = (List)subjectMap.get(key);
                if (subjectList == null || subjectList.size() <= 0) continue;
                if (subjectList.size() > 1) {
                    Boolean isParent = false;
                    String projectName = "";
                    for (EngdepartRespcostDetailVO entity : subjectList) {
                        projectName = projectName.length() > 0 ? projectName + "," + entity.getProjectName() : projectName + entity.getProjectName();
                        if (!pids.contains(entity.getId())) continue;
                        isParent = true;
                    }
                    if (isParent.booleanValue()) {
                        EngdepartRespcostDetailVO vo = (EngdepartRespcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class));
                        vo.setProjectName(projectName);
                        vo.setId((Long)idMap.get(vo.getId()));
                        if (vo.getPid() != null) {
                            vo.setPid((Long)idMap.get(vo.getId()));
                        }
                        detailList.add(vo);
                        continue;
                    }
                    EngdepartRespcostDetailVO vo1 = (EngdepartRespcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class));
                    Long id = IdWorker.getId();
                    EngdepartRespcostDetailVO d = new EngdepartRespcostDetailVO();
                    d.setAddState(vo1.getAddState());
                    d.setFeeType(vo1.getFeeType());
                    d.setSubjectCode(vo1.getSubjectCode());
                    d.setSubjectId(vo1.getSubjectId());
                    d.setSubjectName(vo1.getSubjectName());
                    d.setProjectName(projectName);
                    d.setPid((Long)idMap.get(vo1.getPid()));
                    d.setId(id);
                    detailList.add(d);
                    for (EngdepartRespcostDetailVO entity : subjectList) {
                        EngdepartRespcostDetailVO vo = (EngdepartRespcostDetailVO)((Object)BeanMapper.map((Object)((Object)entity), EngdepartRespcostDetailVO.class));
                        vo.setPid(id);
                        vo.setId(IdWorker.getId());
                        detailList.add(vo);
                    }
                    continue;
                }
                EngdepartRespcostDetailVO vo = (EngdepartRespcostDetailVO)((Object)BeanMapper.map(subjectList.get(0), EngdepartRespcostDetailVO.class));
                if (vo.getPid() != null) {
                    vo.setPid((Long)idMap.get(vo.getPid()));
                }
                vo.setId((Long)idMap.get(vo.getId()));
                detailList.add(vo);
            }
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.sort(Comparator.comparing(EngdepartRespcostDetailVO::getSubjectCode, Comparator.nullsLast(String::compareTo)).thenComparing(EngdepartRespcostDetailVO::getProjectId, Comparator.nullsLast(Long::compare)).thenComparing(BaseVO::getId, Comparator.nullsLast(Long::compare)));
                detailList = this.createTreeData1(detailList);
                for (int i = 0; i < detailList.size(); ++i) {
                    EngdepartRespcostDetailVO vo = detailList.get(i);
                    String code = String.valueOf(i + 1);
                    vo.setCode(code);
                    BigDecimal camount = this.addAllAmount(vo, code);
                    vo.setAmount(camount);
                }
            }
        }
        json.put("projectList", data);
        json.put("detailList", detailList);
        return json;
    }

    @Override
    public void backData(ProjectTargetcostEntity targetcostEntity) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prjcontract_targetcost_id", (Object)targetcostEntity.getId());
        EngdepartRespcostEntity entity = (EngdepartRespcostEntity)((Object)this.getOne((Wrapper)wrapper));
        if (entity != null) {
            if (entity.getBillState() == 0) {
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"respcost_id", (Object)entity.getId());
                this.engdepartRespcostDetailService.remove((Wrapper)detailWrapper);
                this.removeById(entity.getId());
            } else {
                throw new BusinessException("\u8be5\u5355\u636e\u751f\u6210\u7684\u5de5\u7a0b\u90e8\u8d23\u4efb\u6210\u672c\u4e14\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1");
            }
        }
    }

    @Override
    public EngdepartRespcostVO queryDetailByProjectId(Long projectId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(EngdepartRespcostEntity::getProjectId, (Object)projectId)).eq(BaseEntity::getDr, (Object)0)).in(EngdepartRespcostEntity::getBillState, Arrays.asList(1, 3))).orderByDesc(BaseEntity::getCreateTime)).last("limit 1");
        List list = super.list((Wrapper)lambdaQueryWrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (EngdepartRespcostVO)((Object)BeanMapper.map(list.get(0), EngdepartRespcostVO.class));
    }

    public List<EngdepartRespcostDetailVO> createTreeData1(List<EngdepartRespcostDetailVO> list) {
        ArrayList<EngdepartRespcostDetailVO> resp = new ArrayList<EngdepartRespcostDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, EngdepartRespcostDetailVO> listMap = new HashMap<String, EngdepartRespcostDetailVO>();
        for (EngdepartRespcostDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            EngdepartRespcostDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            EngdepartRespcostDetailVO parent = (EngdepartRespcostDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<EngdepartRespcostDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<EngdepartRespcostDetailVO> children = new ArrayList<EngdepartRespcostDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((EngdepartRespcostDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private BigDecimal addAllAmount(EngdepartRespcostDetailVO vo, String pcode) {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = vo.getAmount() != null ? vo.getAmount() : new BigDecimal(0);
        if (vo.getChildren() != null && vo.getChildren().size() > 0) {
            vo.setProjectId(null);
            amount = new BigDecimal(0);
            for (int i = 0; i < vo.getChildren().size(); ++i) {
                EngdepartRespcostDetailVO c = vo.getChildren().get(i);
                String code = null;
                code = StringUtils.isNotBlank((CharSequence)pcode) ? pcode + "." + (i + 1) : String.valueOf(i + 1);
                c.setCode(code);
                BigDecimal camount = this.addAllAmount(c, code);
                amount = amount.add(camount);
            }
            vo.setAmount(amount);
        }
        return amount;
    }
}

