/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.bean.ProjectTargetcostEntity;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.service.IProjectTargetcostChangeService;
import com.ejianc.business.cost.service.IProjectTargetcostService;
import com.ejianc.business.cost.utils.ProjectUtils;
import com.ejianc.business.cost.vo.ProjectTargetcostChangeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectTargetcostChange"})
public class ProjectTargetcostChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectTargetcostChangeService service;
    @Autowired
    private IProjectTargetcostService targetcostService;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;
    @Autowired
    private ProjectUtils projectUtils;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @RequestMapping(value={"/saveChange"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> saveChange(@RequestBody ProjectTargetcostChangeVO saveOrUpdateVO) {
        return this.service.saveChange(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> queryDetail(Long id) {
        return this.service.queryDetail(id);
    }

    @RequestMapping(value={"/queryDetailByTargetcostId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTargetcostChangeVO> queryDetailByTargetcostId(@RequestParam(value="targetcostId") Long targetcostId) {
        return this.service.queryDetailByTargetcostId(targetcostId);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTargetcostChangeVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectTargetcostChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        if (param.getParams().get("taskcostId") == null) {
            throw new BusinessException("\u7f3a\u5c11\u9879\u76ee\u76ee\u6807\u6210\u672cid");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTargetcostChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkBillParam"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody ProjectTargetcostChangeVO vo) {
        CommonResponse dataResponse;
        BigDecimal va;
        BigDecimal roleValue;
        CommonResponse param;
        BigDecimal oldTargetcostTotal;
        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
        JSONArray list = new JSONArray();
        BigDecimal targetcostTotal = vo.getTargetcostTotal() != null ? vo.getTargetcostTotal() : new BigDecimal(0);
        ProjectTargetcostEntity targetcostEntity = (ProjectTargetcostEntity)((Object)this.targetcostService.selectById(vo.getTaskcostId()));
        BigDecimal bigDecimal = oldTargetcostTotal = targetcostEntity.getTargetcostTotal() != null ? targetcostEntity.getTargetcostTotal() : new BigDecimal(0);
        if (oldTargetcostTotal.compareTo(targetcostTotal) > 0) {
            JSONObject item = new JSONObject();
            item.put("type", (Object)"P-L64oPo0311");
            item.put("warnItem", (Object)(list.size() + 1 + ""));
            item.put("warnName", (Object)"\u9879\u76ee\u76ee\u6807\u6210\u672c\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c\u53d8\u66f4");
            item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + oldTargetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u53d8\u66f4\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + oldTargetcostTotal.setScale(2) + "\u5143"));
            list.add((Object)item);
        }
        if ((param = this.paramConfigApi.getBillParamByCode("P-L64oPo0311")).isSuccess() && param.getData() != null && (roleValue = ((BillParamVO)param.getData()).getRoleValue()).compareTo(va = targetcostTotal.subtract(oldTargetcostTotal).divide(oldTargetcostTotal, mc).multiply(new BigDecimal(100))) > 0) {
            JSONObject item = new JSONObject();
            item.put("type", (Object)"P-L64oPo0311");
            item.put("warnItem", (Object)(list.size() + 1 + ""));
            item.put("warnName", (Object)"\u9879\u76ee\u76ee\u6807\u6210\u672c\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c\u53d8\u66f4");
            item.put("content", (Object)("\u9879\u76ee\u76ee\u6807\u6210\u672c\u53d8\u66f4\u91d1\u989d\uff1e\u9879\u76ee\u76ee\u6807\u6210\u672c\u91d1\u989d10%\uff0c\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + oldTargetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u53d8\u66f4\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + oldTargetcostTotal.setScale(2) + "\u5143"));
            list.add((Object)item);
        }
        if ((dataResponse = this.paramConfigApi.getBillParamByCode("P-m69ri60308")).isSuccess()) {
            BigDecimal costTaxTotal;
            BigDecimal roleValue2 = ((BillParamVO)dataResponse.getData()).getRoleValue();
            PreBidCostCalcEntity preBidCostCalcEntity = this.preBidCostCalcService.queryDataByProjectId(vo.getProjectId());
            if (preBidCostCalcEntity == null) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8be5\u9879\u76ee\u6807\u524d\u6d4b\u7b97\u6570\u636e\uff0c\u8bf7\u5148\u5b8c\u6210\u6807\u524d\u6d4b\u7b97");
            }
            BigDecimal bigDecimal2 = costTaxTotal = preBidCostCalcEntity.getCostTaxTotal() != null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);
            if ("\u5b50\u9879\u76ee".equals(vo.getProjectProperty())) {
                List<Long> projectIds = this.projectUtils.getProjectList(vo.getProjectId());
                if (projectIds != null && projectIds.size() > 0) {
                    QueryWrapper wrappera = new QueryWrapper();
                    wrappera.in((Object)"project_id", projectIds);
                    List lsit = this.targetcostService.list((Wrapper)wrappera);
                    if (lsit != null && lsit.size() > 0) {
                        BigDecimal amont = vo.getTargetcostTotal() != null ? vo.getTargetcostTotal() : new BigDecimal(0);
                        for (ProjectTargetcostEntity pr : lsit) {
                            BigDecimal targetcostTotalq = pr.getTargetcostTotal() != null ? pr.getTargetcostTotal() : new BigDecimal(0);
                            amont = amont.add(targetcostTotalq);
                        }
                        BigDecimal absoluteValue = amont.subtract(costTaxTotal);
                        BigDecimal da = new BigDecimal(0);
                        if (costTaxTotal.compareTo(new BigDecimal(0)) != 0) {
                            da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                        }
                        if (da.compareTo(roleValue2) > 0) {
                            JSONObject item = new JSONObject();
                            item.put("type", (Object)"1");
                            item.put("warnItem", (Object)"1");
                            item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                            item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + amont.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                            list.add((Object)item);
                        }
                    }
                } else {
                    BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                    BigDecimal da = new BigDecimal(0);
                    if (costTaxTotal.compareTo(new BigDecimal(0)) != 0) {
                        da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                    }
                    if (da.compareTo(roleValue2) > 0) {
                        JSONObject item = new JSONObject();
                        item.put("type", (Object)"1");
                        item.put("warnItem", (Object)"1");
                        item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                        item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + targetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                        list.add((Object)item);
                    }
                }
            } else {
                BigDecimal absoluteValue = targetcostTotal.subtract(costTaxTotal);
                BigDecimal da = new BigDecimal(0);
                if (costTaxTotal.compareTo(new BigDecimal(0)) != 0) {
                    da = absoluteValue.divide(costTaxTotal, mc).multiply(new BigDecimal(100));
                }
                if (da.compareTo(roleValue2) > 0) {
                    JSONObject item = new JSONObject();
                    item.put("type", (Object)"1");
                    item.put("warnItem", (Object)"1");
                    item.put("warnName", (Object)"\u6807\u524d\u6d4b\u7b97\u63a7\u9879\u76ee\u76ee\u6807\u6210\u672c");
                    item.put("content", (Object)("\u3010\u9879\u76ee\u76ee\u6807\u6210\u672c\u3011\u7684\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a" + targetcostTotal.setScale(2) + "\u5143\uff0c\u5927\u4e8e\u3010\u6807\u524d\u6d4b\u7b97\u3011\u7684\u9879\u76ee\u6210\u672c\uff1a" + costTaxTotal.setScale(2) + "\u5143"));
                    list.add((Object)item);
                }
            }
        }
        return CommonResponse.success((Object)list);
    }
}

