/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.enums.PurchaseTypeEnum;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubRecordService;
import com.ejianc.business.sub.service.ISubSettleService;
import com.ejianc.business.sub.vo.SubContractDetailVO;
import com.ejianc.business.sub.vo.SubContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subContract"})
public class SubContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractService contractService;
    @Autowired
    ISubRecordService recordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubContractVO> saveOrUpdate(@RequestBody SubContractVO contractVO) {
        SubContractVO vo = this.contractService.insertOrUpdate(contractVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryRecordDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubContractVO> queryRecordDetail(Long id) {
        SubContractVO vo = this.recordService.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubContractVO> queryDetail(Long id) {
        SubContractVO vo = this.contractService.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> queryList(@RequestBody QueryParam param) {
        return this.contractService.queryListVOs(param);
    }

    @RequestMapping(value={"/queryPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("contractTaxMny");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.contractService.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), SubContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        this.logger.info(">>>>>>>>>>>>>>>>pageList\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b");
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.contractService.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), SubContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        this.logger.info(">>>>>>>>>>pageList\u8fd4\u56de\uff1a" + page.toJSONString());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubContractVO> Ids) {
        return this.contractService.deleteByIds(Ids);
    }

    @RequestMapping(value={"/contractRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> contractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("contractStatus", new Parameter("ne", (Object)3));
        Long orgId = null;
        String type = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            this.logger.info("condition is " + condition);
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("type")) {
                type = conditionMap.get("type").toString();
            }
            if ("mobileLeave".equals(type)) {
                if (null != conditionMap.get("projectId")) {
                    queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    ComplexParam in = new ComplexParam();
                    in.setLogic("and");
                    ComplexParam p = new ComplexParam();
                    p.setLogic("or");
                    p.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                    ComplexParam t2 = new ComplexParam();
                    t2.setLogic("or");
                    t2.getParams().put("purchaseType", new Parameter("eq", (Object)2));
                    in.getComplexParams().add(p);
                    in.getComplexParams().add(t2);
                    queryParam.getComplexParams().add(in);
                }
            } else if (null != conditionMap.get("projectId")) {
                queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
            } else if (null != conditionMap.get("supplierId")) {
                Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
            }
        }
        if (type != null && "pay".equals(type)) {
            queryParam.getComplexParams().add(this.getComplexParamForPay(orgId));
            queryParam.getParams().remove("contractStatus");
        } else if (!"mobileLeave".equals(type)) {
            queryParam.getComplexParams().add(this.getPageQueryParam(null));
            ArrayList billStateList = new ArrayList();
            this.logger.debug("type is " + type);
            if (type != null && "finish".equals(type)) {
                queryParam.getParams().put("purchase_type", new Parameter("ne", (Object)PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode()));
            }
            if (type == null || !"receive".equals(type) || !"settleReport".equals(type)) {
                queryParam.getParams().put("finish_flag", new Parameter("ne", (Object)Boolean.TRUE));
            }
        }
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.contractService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List contractVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), SubContractVO.class);
        for (SubContractVO contractVO : contractVOS) {
            contractVO.setContractNameExtend(contractVO.getBillCode() + "-" + contractVO.getContractName() + "-" + contractVO.getSupplierName() + "-" + ComputeUtil.scale((BigDecimal)contractVO.getContractTaxMny(), (int)2));
        }
        result.setRecords(contractVOS);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody SubContractVO contractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVO.getId());
        updateWrapper.set(SubContractEntity::getContractStatus, (Object)contractVO.getContractStatus());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refContractDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> refContractDetail(@RequestParam(value="contractId") Long contractId, @RequestParam(required=false) String condition) {
        List<SubContractDetailVO> contractDetailVOS = this.contractService.refContractDetail(contractId, condition);
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", contractDetailVOS);
    }

    @RequestMapping(value={"/refContractDetailByCondition"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> refContractDetail1(@RequestParam(value="condition") String condition) {
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        Object obj = conditionMap.get("contractId");
        Long contractId = Long.valueOf(obj.toString());
        List<SubContractDetailVO> contractDetailVOS = this.contractService.refContractDetail(contractId, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", contractDetailVOS);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("contractTaxMny");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.contractService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), SubContractVO.class);
        }
        list.forEach(vo -> {
            if ("1".equals(vo.getContractStatus())) {
                vo.setContractStatus("\u672a\u7b7e\u8ba2");
            } else if ("2".equals(vo.getContractStatus())) {
                vo.setContractStatus("\u5c65\u7ea6\u4e2d");
            } else if ("3".equals(vo.getContractStatus())) {
                vo.setContractStatus("\u5df2\u5c01\u8d26");
            }
            vo.setPurchaseType(String.valueOf(PurchaseTypeEnum.\u9879\u76ee\u81ea\u91c7.getCode()).equals(vo.getPurchaseType()) ? "\u81ea\u91c7" : "\u96c6\u91c7");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("subContract-export.xlsx", beans, response);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_type", new Parameter("eq", (Object)PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode()));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contract-detail-import.xlsx", (String)"\u5206\u5305\u5408\u540c\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.contractService.excelImport(request, response);
    }

    @RequestMapping(value={"/queryListBySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubContractEntity>> queryListBySupplierId(Long id) {
        QueryParam parm = new QueryParam();
        parm.getParams().put("supplierId", new Parameter("eq", (Object)id));
        List list = this.contractService.queryList(parm, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)list);
    }

    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("purchase_type", new Parameter("eq", (Object)"1"));
        c2.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if (!allOrgIds.isEmpty()) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_type", new Parameter("eq", (Object)"2"));
            c3.getParams().put("org_id", new Parameter("in", this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    public List<Long> getOrgUpToDownList() {
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u672c\u4e0a\u52a0\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentIds = new ArrayList();
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }

    @RequestMapping(value={"/getSubContractTotalAmount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getSubContractTotalAmount(@RequestBody List<Long> projectIds) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("purchaseType", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        }
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        List contractEntities = this.contractService.queryList(queryParam, false);
        List settleEntities = this.settleService.queryList(queryParam, false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (BaseEntity c : contractEntities) {
                if (c.getContractTaxMny() == null) continue;
                contract = contract.add(c.getContractTaxMny());
            }
        }
        if (ListUtil.isNotEmpty((List)settleEntities)) {
            for (BaseEntity c : settleEntities) {
                if (c.getContractTaxMny() == null) continue;
                settle = settle.add(c.getContractTaxMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        return CommonResponse.success((Object)back);
    }

    @PostMapping(value={"/analysisContract"})
    @ResponseBody
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("purchaseType", new Parameter("eq", (Object)1));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        String dataStr = null != (result = this.contractService.countContractAmount(queryParam)).get("contractTaxMny") ? result.get("contractTaxMny").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    @RequestMapping(value={"/subContractRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> subContractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
                queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
            } else {
                queryParam.getComplexParams().add(this.getPageQueryParam(null));
            }
        } else {
            queryParam.getComplexParams().add(this.getPageQueryParam(null));
        }
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.contractService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List contractVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), SubContractVO.class);
        for (SubContractVO contractVO : contractVOS) {
            contractVO.setContractNameExtend(contractVO.getBillCode() + "-" + contractVO.getContractName() + "-" + contractVO.getSupplierName() + "-" + ComputeUtil.scale((BigDecimal)contractVO.getContractTaxMny(), (int)2));
        }
        result.setRecords(contractVOS);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/refSubDataTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<JSONObject> refSubDataTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Boolean productionFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"productionFlag") != null) {
                productionFlag = true;
            }
        }
        List page = this.contractService.queryList(param, false);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        List<Object> haveSurNumIds = new ArrayList();
        if (productionFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)page)) {
            Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("contractId", new Parameter("in", page.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            List<SubContractDetailVO> detailList = this.contractService.queryApplySubCount((IPage)pageData, queryApplySubParam);
            haveSurNumIds = detailList.stream().map(SubContractDetailVO::getContractId).collect(Collectors.toList());
        }
        if (page != null && page.size() > 0) {
            for (SubContractEntity entity : page) {
                if (productionFlag.booleanValue() && !haveSurNumIds.contains(entity.getId())) continue;
                JSONObject vo = (JSONObject)BeanMapper.map((Object)((Object)entity), JSONObject.class);
                vo.put("name", vo.get((Object)"contractName"));
                list.add(vo);
            }
        }
        return list;
    }

    @RequestMapping(value={"/refSubDataDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubDataDetail(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long contractId = null;
        Boolean productionFlag = false;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            contractId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"productionFlag") != null) {
                productionFlag = true;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            _con = JSONObject.parseObject((String)condition);
        }
        Page pageData = new Page((long)pageNumber, (long)pageSize);
        List<SubContractDetailVO> detailList = null;
        if (productionFlag.booleanValue()) {
            detailList = this.contractService.queryApplySubCount((IPage)pageData, param);
        }
        pageData.setRecords(detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

