package com.ejianc.business.base.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 班组基础库
 *
 * @author generator
 */
public class BaseTeamVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName;//项目名称
    private Long corpId; // 班组所在企业
    private String corpCode; // 班组所在企业统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    private String corpName; // 班组所在企业名称
    private String teamName; // 班组名称，同一个项目下面不能重复
    private Long responsiblePersonIdCardType; // 责任人证件类型
    private String responsiblePersonIdCardTypeCode; // 责任人证件类型编码
    private String responsiblePersonIdCardTypeCodeName; // 责任人证件类型编码名称
    private String responsiblePersonName; // 责任人姓名，班组所在企业负责人
    private String responsiblePersonPhone; // 责任人联系电话
    private String responsiblePersonIdNumber; // 责任人证件号码。AES
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date entryTime; // 进场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitTime; // 退场日期
    private String entryAttachments; // 进场附件，有进场日期时，此字段必填。JSON数组。附件总数不超过5个
    private String exitAttachments; // 退场附件，有退场日期时，此字段必填。JSON数组。附件总数不超过5个


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getResponsiblePersonIdCardType() {
        return responsiblePersonIdCardType;
    }
    @ReferDeserialTransfer
    public void setResponsiblePersonIdCardType(Long responsiblePersonIdCardType) {
        this.responsiblePersonIdCardType = responsiblePersonIdCardType;
    }

    public String getResponsiblePersonIdCardTypeCode() {
        return responsiblePersonIdCardTypeCode;
    }

    public void setResponsiblePersonIdCardTypeCode(String responsiblePersonIdCardTypeCode) {
        this.responsiblePersonIdCardTypeCode = responsiblePersonIdCardTypeCode;
    }

    public String getResponsiblePersonIdCardTypeCodeName() {
        return responsiblePersonIdCardTypeCodeName;
    }

    public void setResponsiblePersonIdCardTypeCodeName(String responsiblePersonIdCardTypeCodeName) {
        this.responsiblePersonIdCardTypeCodeName = responsiblePersonIdCardTypeCodeName;
    }

    public String getResponsiblePersonName() {
        return responsiblePersonName;
    }

    public void setResponsiblePersonName(String responsiblePersonName) {
        this.responsiblePersonName = responsiblePersonName;
    }

    public String getResponsiblePersonPhone() {
        return responsiblePersonPhone;
    }

    public void setResponsiblePersonPhone(String responsiblePersonPhone) {
        this.responsiblePersonPhone = responsiblePersonPhone;
    }

    public String getResponsiblePersonIdNumber() {
        return responsiblePersonIdNumber;
    }

    public void setResponsiblePersonIdNumber(String responsiblePersonIdNumber) {
        this.responsiblePersonIdNumber = responsiblePersonIdNumber;
    }

    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public Date getExitTime() {
        return exitTime;
    }

    public void setExitTime(Date exitTime) {
        this.exitTime = exitTime;
    }

    public String getEntryAttachments() {
        return entryAttachments;
    }

    public void setEntryAttachments(String entryAttachments) {
        this.entryAttachments = entryAttachments;
    }

    public String getExitAttachments() {
        return exitAttachments;
    }

    public void setExitAttachments(String exitAttachments) {
        this.exitAttachments = exitAttachments;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}
