package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 企业基本信息
 *
 * @author generator
 */
public class EnterpriseVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private String corpCode; // 企业统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    private String corpName; // 企业名称
    private Long corpTypeId; // 单位性质id
    private String corpTypeCode; // 单位性质编码
    private String corpTypeName; // 单位性质。参考企业登记注册类型字典表
    private String licenseNum; // 工商营业执照注册号
    private Long areaId; // 企业注册地区id
    private String areaName; // 企业注册地区名称
    private String areaCode; // 企业注册地区编码。参考行政区划字典表
    private String address; // 企业营业地址
    private String zipCode; // 邮政编码
    private Long legalManId; // 法定代表人id
    private String legalManName; // 法定代表人姓名
    private String legalManDuty; // 法定代表人职务
    private String legaManProTitle; // 法定代表人职称
    private Long legalManIdCardTypeId; // 法定代表人证件类型id
    private String legalManIdCardTypeCode; // 法定代表人证件类型编码
    private String legalManIdCardTypeName; // 法定代表人证件类型。参考人员证件类型字典表
    private String legalManIdCardNumber; // 法定代表人证件号码。AES
    private BigDecimal regCapital; // 注册资本（万元）
    private BigDecimal factRegCapital; // 实收资本(万元)
    private Long capitalCurrencyTypeId; // 注册资本币种id
    private String capitalCurrencyTypeCode; // 注册资本币种编码
    private String capitalCurrencyTypeName; // 注册资本币种。参考币种字典表
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate; // 注册日期，格式yyyy-MM-dd
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishDate; // 成立日期，格式yyyy-MM-dd
    private String officePhone; // 办公电话
    private String faxNumber; // 传真号码
    private String linkMan; // 联系人姓名
    private String linkPhone; // 联系人办公电话
    private String email; // 企业联系邮箱
    private String website; // 企业网址
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCorpTypeId() {
        return corpTypeId;
    }

    @ReferDeserialTransfer
    public void setCorpTypeId(Long corpTypeId) {
        this.corpTypeId = corpTypeId;
    }

    public String getCorpTypeCode() {
        return corpTypeCode;
    }

    public void setCorpTypeCode(String corpTypeCode) {
        this.corpTypeCode = corpTypeCode;
    }

    public String getCorpTypeName() {
        return corpTypeName;
    }

    public void setCorpTypeName(String corpTypeName) {
        this.corpTypeName = corpTypeName;
    }

    public String getLicenseNum() {
        return licenseNum;
    }

    public void setLicenseNum(String licenseNum) {
        this.licenseNum = licenseNum;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getAreaId() {
        return areaId;
    }
    @ReferDeserialTransfer
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getLegalManId() {
        return legalManId;
    }

    @ReferDeserialTransfer
    public void setLegalManId(Long legalManId) {
        this.legalManId = legalManId;
    }

    public String getLegalManName() {
        return legalManName;
    }

    public void setLegalManName(String legalManName) {
        this.legalManName = legalManName;
    }

    public String getLegalManDuty() {
        return legalManDuty;
    }

    public void setLegalManDuty(String legalManDuty) {
        this.legalManDuty = legalManDuty;
    }

    public String getLegaManProTitle() {
        return legaManProTitle;
    }

    public void setLegaManProTitle(String legaManProTitle) {
        this.legaManProTitle = legaManProTitle;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getLegalManIdCardTypeId() {
        return legalManIdCardTypeId;
    }

    @ReferDeserialTransfer
    public void setLegalManIdCardTypeId(Long legalManIdCardTypeId) {
        this.legalManIdCardTypeId = legalManIdCardTypeId;
    }

    public String getLegalManIdCardTypeCode() {
        return legalManIdCardTypeCode;
    }

    public void setLegalManIdCardTypeCode(String legalManIdCardTypeCode) {
        this.legalManIdCardTypeCode = legalManIdCardTypeCode;
    }

    public String getLegalManIdCardTypeName() {
        return legalManIdCardTypeName;
    }

    public void setLegalManIdCardTypeName(String legalManIdCardTypeName) {
        this.legalManIdCardTypeName = legalManIdCardTypeName;
    }

    public String getLegalManIdCardNumber() {
        return legalManIdCardNumber;
    }

    public void setLegalManIdCardNumber(String legalManIdCardNumber) {
        this.legalManIdCardNumber = legalManIdCardNumber;
    }

    public BigDecimal getRegCapital() {
        return regCapital;
    }

    public void setRegCapital(BigDecimal regCapital) {
        this.regCapital = regCapital;
    }

    public BigDecimal getFactRegCapital() {
        return factRegCapital;
    }

    public void setFactRegCapital(BigDecimal factRegCapital) {
        this.factRegCapital = factRegCapital;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCapitalCurrencyTypeId() {
        return capitalCurrencyTypeId;
    }

    @ReferDeserialTransfer
    public void setCapitalCurrencyTypeId(Long capitalCurrencyTypeId) {
        this.capitalCurrencyTypeId = capitalCurrencyTypeId;
    }

    public String getCapitalCurrencyTypeCode() {
        return capitalCurrencyTypeCode;
    }

    public void setCapitalCurrencyTypeCode(String capitalCurrencyTypeCode) {
        this.capitalCurrencyTypeCode = capitalCurrencyTypeCode;
    }

    public String getCapitalCurrencyTypeName() {
        return capitalCurrencyTypeName;
    }

    public void setCapitalCurrencyTypeName(String capitalCurrencyTypeName) {
        this.capitalCurrencyTypeName = capitalCurrencyTypeName;
    }

    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }

    public String getOfficePhone() {
        return officePhone;
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }

    public String getFaxNumber() {
        return faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getLinkMan() {
        return linkMan;
    }

    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
