package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.labor.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目班组
 * 
 * @author generator
 * 
 */
public class ProjectTeamVO extends BaseVO{
    private static final long serialVersionUID = 1L;
    
    private Integer sourceFlag; // 来源标识（0自制、1公司班组）
    private Long sourceOrgTeamId; // 来源公司班组ID
    private String innerCode; // innerCode
    private String innerCodeName; // innerCode
    private Long parentId; // 父ID
    private String code; // 编码
    private String name; // 班组名称
    private String leaderName; // 班组长名称
    private String phone; // 手机号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织id
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgName; // 项目部所属组织
    private String memo; // 备注
    private Boolean isLeaf; // 是否是叶子节点
    private Long sourceParentId; // 来源公司班组 父ID
    private String parentCode;//上级编码
    private String parentName; //上级名称
    private String sourceType; //类型(1-公司 2-队伍 3-班组)
    private Long sourceId; //来源id
    private Long teamType; //种类
    private String teamTypeName; //种类名称
    private String idCard; //身份证
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceDate;//入场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceOutDate;//出场日期
    private String serviceStatus;//进场状态
    private List<ProjectTeamVO> children;


    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Long getSourceParentId() {
        return sourceParentId;
    }

    public void setSourceParentId(Long sourceParentId) {
        this.sourceParentId = sourceParentId;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean leaf) {
        isLeaf = leaf;
    }

    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public Long getSourceOrgTeamId() {
        return sourceOrgTeamId;
    }

    public void setSourceOrgTeamId(Long sourceOrgTeamId) {
        this.sourceOrgTeamId = sourceOrgTeamId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    @ReferSerialTransfer(referCode="projectTeamRef")
    public Long getParentId() {
        return parentId;
    }
    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getLeaderName() {
        return leaderName;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
//    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
//    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
//    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
//    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
//    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
//    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Boolean getLeaf() {
        return isLeaf;
    }

    public void setLeaf(Boolean leaf) {
        isLeaf = leaf;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getTeamType() {
        return teamType;
    }
    @ReferDeserialTransfer
    public void setTeamType(Long teamType) {
        this.teamType = teamType;
    }

    public String getTeamTypeName() {
        return teamTypeName;
    }

    public void setTeamTypeName(String teamTypeName) {
        this.teamTypeName = teamTypeName;
    }

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public List<ProjectTeamVO> getChildren() {
        return children;
    }

    public void setChildren(List<ProjectTeamVO> children) {
        this.children = children;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public Date getServiceOutDate() {
        return serviceOutDate;
    }

    public void setServiceOutDate(Date serviceOutDate) {
        this.serviceOutDate = serviceOutDate;
    }

    public String getServiceStatus() {
        return serviceStatus;
    }

    public void setServiceStatus(String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public String getInnerCodeName() {
        return innerCodeName;
    }

    public void setInnerCodeName(String innerCodeName) {
        this.innerCodeName = innerCodeName;
    }
}
