package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labor.vo.BuildLicenseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目信息
 *
 * @author generator
 */
public class PorjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private String contractorCorpCode; // 总承包单位统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    private String contractorCorpName; // 总承包单位名称
    private String name; // 项目名称
    private String description; // 项目简介
    private Long categoryId; // 项目分类id
    private String categoryCode; // 项目分类编码
    private String categoryName; // 项目分类。参见项目分类字典表
    private String buildCorpName; // 建设单位名称
    private String buildCorpCode; // 建设单位统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    private String buildPlanNum; // 建设用地规划许可证编号。
    private String prjPlanNum; // 建设工程规划许可证编号。
    private String areaId; // 项目所在地id
    private String areaName; // 项目所在地名称
    private String areaCode; // 项目所在地。参考行政区划字典表
    private BigDecimal invest; // 总投资，单位：（万元）
    private BigDecimal buildingArea; // 总面积，单位：平方米
    private BigDecimal buildingLength; // 总长度，单位：米
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期，精确到天，格式：yyyy-MM-dd
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completeDate; // 竣工日期，精确到天，格式：yyyy-MM-dd
    private String linkMan; // 联系人姓名
    private String linkPhone; // 联系人办公电话
    private Long prjStatusId; // 项目状态id
    private String prjStatusCode; // 项目状态编码
    private String prjStatusName; // 项目状态。参考项目状态字典表
    private BigDecimal lat; // WGS84经度
    private BigDecimal lng; // WGS84纬度
    private String address; // 项目地点
    private String approvalNum; // 立项文号
    private Long approvalLevelId; // 立项级别id
    private String approvalLevelCode; // 立项级别编码
    private String approvalLevelName; // 立项级别。参考立项级别字典表
    private Long prjSizeId; // 建设规模id
    private String prjSizeCode; // 建设规模编码
    private String prjSizeName; // 建设规模。参考建设规模字典表
    private Long propertyNumId; // 建设性质id
    private String propertyNumCode; // 建设性质编码
    private String propertyNumName; // 建设性质。参考建设性质分类字典表
    private Long functionNumId; // 工程用途id
    private String functionNumCode; // 工程用途编码
    private String functionNumName; // 工程用途。参考工程用途字典表
    private Long nationNumId; // 国籍地区id
    private String nationNumCode; // 国籍地区编码
    private String nationNumName; // 国籍或地区。参考国籍及地区字典表
    private String location; // 施工许可证颁发单位所在地行政区划编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String regionId;//设备位置唯一标识
    private String groupId;//分组唯一标识
    private String conType;//硬件平台
    private Long innerProjectId;//pm项目
    private Long buildCorpId; // 建设单位
    private Long contractorCorpId; // 总承包单位

    private List<BuildLicenseVO> buildLicenseList = new ArrayList<>(); // 项目施工许可证子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractorCorpCode() {
        return contractorCorpCode;
    }

    public void setContractorCorpCode(String contractorCorpCode) {
        this.contractorCorpCode = contractorCorpCode;
    }

    public String getContractorCorpName() {
        return contractorCorpName;
    }

    public void setContractorCorpName(String contractorCorpName) {
        this.contractorCorpName = contractorCorpName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCategoryId() {
        return categoryId;
    }

    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getBuildCorpName() {
        return buildCorpName;
    }

    public void setBuildCorpName(String buildCorpName) {
        this.buildCorpName = buildCorpName;
    }

    public String getBuildCorpCode() {
        return buildCorpCode;
    }

    public void setBuildCorpCode(String buildCorpCode) {
        this.buildCorpCode = buildCorpCode;
    }

    public String getBuildPlanNum() {
        return buildPlanNum;
    }

    public void setBuildPlanNum(String buildPlanNum) {
        this.buildPlanNum = buildPlanNum;
    }

    public String getPrjPlanNum() {
        return prjPlanNum;
    }

    public void setPrjPlanNum(String prjPlanNum) {
        this.prjPlanNum = prjPlanNum;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public BigDecimal getInvest() {
        return invest;
    }

    public void setInvest(BigDecimal invest) {
        this.invest = invest;
    }

    public BigDecimal getBuildingArea() {
        return buildingArea;
    }

    public void setBuildingArea(BigDecimal buildingArea) {
        this.buildingArea = buildingArea;
    }

    public BigDecimal getBuildingLength() {
        return buildingLength;
    }

    public void setBuildingLength(BigDecimal buildingLength) {
        this.buildingLength = buildingLength;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getCompleteDate() {
        return completeDate;
    }

    public void setCompleteDate(Date completeDate) {
        this.completeDate = completeDate;
    }

    public String getLinkMan() {
        return linkMan;
    }

    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }

    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPrjStatusId() {
        return prjStatusId;
    }

    @ReferDeserialTransfer
    public void setPrjStatusId(Long prjStatusId) {
        this.prjStatusId = prjStatusId;
    }

    public String getPrjStatusCode() {
        return prjStatusCode;
    }

    public void setPrjStatusCode(String prjStatusCode) {
        this.prjStatusCode = prjStatusCode;
    }

    public String getPrjStatusName() {
        return prjStatusName;
    }

    public void setPrjStatusName(String prjStatusName) {
        this.prjStatusName = prjStatusName;
    }

    public BigDecimal getLat() {
        return lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLng() {
        return lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getApprovalNum() {
        return approvalNum;
    }

    public void setApprovalNum(String approvalNum) {
        this.approvalNum = approvalNum;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getApprovalLevelId() {
        return approvalLevelId;
    }

    @ReferDeserialTransfer
    public void setApprovalLevelId(Long approvalLevelId) {
        this.approvalLevelId = approvalLevelId;
    }

    public String getApprovalLevelCode() {
        return approvalLevelCode;
    }

    public void setApprovalLevelCode(String approvalLevelCode) {
        this.approvalLevelCode = approvalLevelCode;
    }

    public String getApprovalLevelName() {
        return approvalLevelName;
    }

    public void setApprovalLevelName(String approvalLevelName) {
        this.approvalLevelName = approvalLevelName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPrjSizeId() {
        return prjSizeId;
    }

    @ReferDeserialTransfer
    public void setPrjSizeId(Long prjSizeId) {
        this.prjSizeId = prjSizeId;
    }

    public String getPrjSizeCode() {
        return prjSizeCode;
    }

    public void setPrjSizeCode(String prjSizeCode) {
        this.prjSizeCode = prjSizeCode;
    }

    public String getPrjSizeName() {
        return prjSizeName;
    }

    public void setPrjSizeName(String prjSizeName) {
        this.prjSizeName = prjSizeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPropertyNumId() {
        return propertyNumId;
    }

    @ReferDeserialTransfer
    public void setPropertyNumId(Long propertyNumId) {
        this.propertyNumId = propertyNumId;
    }

    public String getPropertyNumCode() {
        return propertyNumCode;
    }

    public void setPropertyNumCode(String propertyNumCode) {
        this.propertyNumCode = propertyNumCode;
    }

    public String getPropertyNumName() {
        return propertyNumName;
    }

    public void setPropertyNumName(String propertyNumName) {
        this.propertyNumName = propertyNumName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFunctionNumId() {
        return functionNumId;
    }

    @ReferDeserialTransfer
    public void setFunctionNumId(Long functionNumId) {
        this.functionNumId = functionNumId;
    }

    public String getFunctionNumCode() {
        return functionNumCode;
    }

    public void setFunctionNumCode(String functionNumCode) {
        this.functionNumCode = functionNumCode;
    }

    public String getFunctionNumName() {
        return functionNumName;
    }

    public void setFunctionNumName(String functionNumName) {
        this.functionNumName = functionNumName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getNationNumId() {
        return nationNumId;
    }

    @ReferDeserialTransfer
    public void setNationNumId(Long nationNumId) {
        this.nationNumId = nationNumId;
    }

    public String getNationNumCode() {
        return nationNumCode;
    }

    public void setNationNumCode(String nationNumCode) {
        this.nationNumCode = nationNumCode;
    }

    public String getNationNumName() {
        return nationNumName;
    }

    public void setNationNumName(String nationNumName) {
        this.nationNumName = nationNumName;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<BuildLicenseVO> getBuildLicenseList() {
        return buildLicenseList;
    }

    public void setBuildLicenseList(List<BuildLicenseVO> buildLicenseList) {
        this.buildLicenseList = buildLicenseList;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getConType() {
        return conType;
    }

    public void setConType(String conType) {
        this.conType = conType;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getInnerProjectId() {
        return innerProjectId;
    }
    @ReferDeserialTransfer
    public void setInnerProjectId(Long innerProjectId) {
        this.innerProjectId = innerProjectId;
    }
    @ReferSerialTransfer(referCode = "support-customer,support-supplier")
    public Long getBuildCorpId() {
        return buildCorpId;
    }
    @ReferDeserialTransfer
    public void setBuildCorpId(Long buildCorpId) {
        this.buildCorpId = buildCorpId;
    }

    public Long getContractorCorpId() {
        return contractorCorpId;
    }

    public void setContractorCorpId(Long contractorCorpId) {
        this.contractorCorpId = contractorCorpId;
    }
}
