package com.ejianc.business.other.dangong.vo;

/**
 * @Author: jiang
 * @Date: 2025/8/7 10:25
 **/

import java.io.Serializable;

/**
 * 通用API响应封装
 *
 * @param <T> 数据泛型
 */

public class DanGongPublicResultVO<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 状态码
     */
    private int code;

    /**
     * 返回消息
     */
    private String message;

    /**
     * 时间戳
     */
    private Object time;

    /**
     * 事件标识
     */
    private String event;

    /**
     * 返回数据
     */
    private T data;

    public DanGongPublicResultVO() {
        this.time = System.currentTimeMillis() / 1000;
    }

    // ========== 成功方法 ==========

    public static <T> DanGongPublicResultVO<T> success() {
        DanGongPublicResultVO<T> result = new DanGongPublicResultVO<>();
        result.setSuccess(true);
        result.setCode(0);
        result.setMessage("success");
        return result;
    }

    public static <T> DanGongPublicResultVO<T> success(T data) {
        DanGongPublicResultVO<T> result = success();
        result.setData(data);
        return result;
    }

    public static <T> DanGongPublicResultVO<T> success(String event, T data) {
        DanGongPublicResultVO<T> result = success(data);
        result.setEvent(event);
        return result;
    }

    public static <T> DanGongPublicResultVO<T> success(String event, String message, T data) {
        DanGongPublicResultVO<T> result = success(message, data);
        result.setEvent(event);
        return result;
    }

    // ========== 失败方法 ==========

    public static <T> DanGongPublicResultVO<T> fail() {
        DanGongPublicResultVO<T> result = new DanGongPublicResultVO<>();
        result.setSuccess(false);
        result.setCode(-1);
        result.setMessage("fail");
        return result;
    }

    public static <T> DanGongPublicResultVO<T> fail(int code, String message) {
        DanGongPublicResultVO<T> result = fail();
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public static <T> DanGongPublicResultVO<T> fail(int code, String message, String event) {
        DanGongPublicResultVO<T> result = fail(code, message);
        result.setEvent(event);
        return result;
    }

    public static <T> DanGongPublicResultVO<T> fail(int code, String message, T data, String event) {
        DanGongPublicResultVO<T> result = fail(code, message, event);
        result.setData(data);
        return result;
    }

    // ========== getter和setter ==========

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }
}