package com.ejianc.business.other.henger.vo;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @Author: jiang
 * @Date: 2023/12/27 14:31
 **/
public class HengErRecordVO {
    /**
     * 设备的设备ID号
     */
    private String deviceID;

    /**
     * 控 制 记 录 时 间 。 e.g.,
     * 2018-03-25T21:50:05
     */
    @JsonFormat(pattern = "YYYY-MM-DDThh:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 认证结果
     * 0: 无
     * 1: 允许
     * 2: 拒绝
     * 3: 还没有注册
     * 22:待核验(开门方式为 3:人脸核验+远程开门方式的控制记录)
     * 24:无权限（特殊版本非通行时
     * 间段的控制记录）
     */
    private String verifyStatus;

    /**
     * 验证类型。
     * 1: 白名单验证
     * 2: 身份证验证
     * 3: 白名单 + 身份证验证
     * 21:RF 卡验证(内置刷卡机型)
     * 22:RF 卡验证 + 白名单验证(内置刷卡机型)
     * 24:韦根卡验证
     * 25:韦根卡 + 白名单验证
     * 27:HTTP 远程开门
     *
     * 以下开门方式仅健康码版本支持：
     * 47 二维码或白名单或身份证
     * 48 白名单+二维码 或 白名单+身份
     * 证
     * 55 二维码或身份证或白名单(查健
     * 康码)
     * 56 二维码或身份证跳过刷脸
     * 57 白名单+健康码信息
     */
    private String verfyType;

    /**
     *  名单类型
     * 0: 白名单
     * 1: 黑名单
     */
    private String personType;

    /**
     * 是否是临时名单
     * 0: 永久生效名单
     * 1: 临时名单
     * 2：临时名单 2
     * 3：临时名单 3
     */
    private String tempvalid;

    /**
     * 用户自定义的人员 UUID 号(不超过 48 字节)，
     * 可以通过此 ID 号进行修改删除等管理对应的人员信息。注意: 不可以重复使用相同的 UUID 添加人员，否则会导致修改删除等操作出错
     */
    private Long personUUID;//即workerId


    public String getDeviceID() {
        return deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(String verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public String getVerfyType() {
        return verfyType;
    }

    public void setVerfyType(String verfyType) {
        this.verfyType = verfyType;
    }

    public String getPersonType() {
        return personType;
    }

    public void setPersonType(String personType) {
        this.personType = personType;
    }

    public String getTempvalid() {
        return tempvalid;
    }

    public void setTempvalid(String tempvalid) {
        this.tempvalid = tempvalid;
    }

    public Long getPersonUUID() {
        return personUUID;
    }

    public void setPersonUUID(Long personUUID) {
        this.personUUID = personUUID;
    }

    public static void main(String[] args) {
        long id = IdWorker.getId();
        System.out.println(id);
    }
}
