package com.ejianc.business.labor.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 劳务工资单-用工记录
 * 
 * @author generator
 * 
 */
public class SalaryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long salaryId; // 工人工资单主表id
    private Long workerId; // 工人id
    private String workerName; // 工人
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long supplierId; // 加班计量方式
    private String supplierName; // 加班工作量
    private String idCard; // 身份证号码
    private String teamId; // 班组id
    private String teamName; // 班组名称
    private String workType; // 工种id
    private String workTypeName; // 工种名称
    private Integer sex; // 性別 1:男 2:女
    private String phone; // 手机号
    private String bankCard; // 银行卡号
    private String bankName; // 开户行
    private Integer wagesType; // 工资类型
    private Integer sysCheckNum; // 系统考勤天数
    private BigDecimal price; // 单价
    private BigDecimal actualCheckNum; // 实际考勤
    private BigDecimal mny; // 金额
    private BigDecimal overtimeMny; // 加班费
    private BigDecimal deductMny; // 扣款费用
    private String deductReason; // 扣款原因
    private BigDecimal shouldSalaryMny; // 应发工资:工作量*单价+加班工作量*单价
    private String memo; // 备注
    private Integer source; // 来源 1：花名册 2：自制
    /**
     * 导入失败原因
     */
    private String errorMessage;

    private BigDecimal overtimeWage; // 加班工价

    private BigDecimal overtimeHours; // 加班时长


    public BigDecimal getOvertimeHours() {
        return overtimeHours;
    }

    public void setOvertimeHours(BigDecimal overtimeHours) {
        this.overtimeHours = overtimeHours;
    }

    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }



    public Long getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(Long salaryId) {
        this.salaryId = salaryId;
    }
    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    @ReferSerialTransfer(referCode = "sub-contract-register")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    @ReferSerialTransfer(referCode = "projectTeamRef")
    public String getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getWorkType() {
        return workType;
    }
    @ReferDeserialTransfer
    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }

    public Integer getSysCheckNum() {
        return sysCheckNum;
    }

    public void setSysCheckNum(Integer sysCheckNum) {
        this.sysCheckNum = sysCheckNum;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getActualCheckNum() {
        return actualCheckNum;
    }

    public void setActualCheckNum(BigDecimal actualCheckNum) {
        this.actualCheckNum = actualCheckNum;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getOvertimeMny() {
        return overtimeMny;
    }

    public void setOvertimeMny(BigDecimal overtimeMny) {
        this.overtimeMny = overtimeMny;
    }
    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }
    public String getDeductReason() {
        return deductReason;
    }

    public void setDeductReason(String deductReason) {
        this.deductReason = deductReason;
    }
    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
