package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiEquipEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiEquipApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiEquipVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租赁公司-第三方调用公共方法
 *
 * @author generator
 */
@Service("XiaoShiEquipApiService")
public class XiaoShiEquipApiServiceImpl implements XiaoShiEquipApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IXiaoShiEquipService equipService;
    @Autowired
    private XiaoShiPublicApiService publicApiService;

    @Override
    public List<XiaoShiEquipVO> getEquipPage(Integer pageNum, Integer pageSize) {

        String apiUrl = "/base/device/v1/getList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", pageNum);
        queryParam.put("pageSize", pageSize);
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            return rows.toJavaList(XiaoShiEquipVO.class);
        }
        return null;
    }


    @Override
    public void synEquip() {
        /**
         * 循环调用接口查询，将查询结果保存到数据库，
         * 根据regionId判断，如果有则更新，无则插入；
         */
        boolean flag = true;
        Integer pageNum = 1;
        Integer pageSize = 50;
        int synNum = 0;//同步次数
        List<String> deviceSns = equipService.list().stream().map(XiaoShiEquipEntity::getDeviceSn).collect(Collectors.toList());
        Map<String, Long> deviceSnRefMap = equipService.list().stream().collect(Collectors.toMap(XiaoShiEquipEntity::getDeviceSn, XiaoShiEquipEntity::getId));
        while (flag) {
            List<XiaoShiEquipVO> equipPage = getEquipPage(pageNum, pageSize);
            if (ListUtil.isEmpty(equipPage)) {
                flag = false;
            } else {
                for (XiaoShiEquipVO xiaoShiEquipVO : equipPage) {
                    if (deviceSns.contains(xiaoShiEquipVO.getDeviceSn())) {
                        xiaoShiEquipVO.setId(deviceSnRefMap.get(xiaoShiEquipVO.getDeviceSn()));
                    }
                }
                boolean b = equipService.saveOrUpdateBatch(BeanMapper.mapList(equipPage, XiaoShiEquipEntity.class));
                if(b){
                    synNum++;
                    pageNum++;
                }
                if(equipPage.size() != pageSize){
                    flag = false;
                }

            }
        }
        logger.info("同步成功,共同步"+synNum+"次,每次50条数据");
    }
}
