package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiPersonEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiPersonService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPersonApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonPicVO;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service("XiaoShiPersonApiService")
public class XiaoShiPersonApiServiceImpl implements XiaoShiPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IXiaoShiPersonService personService;
    @Autowired
    private XiaoShiPublicApiService publicApiService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IPorjectService projectService;

    @Override
    public List<XiaoShiPersonVO> getPage(Integer pageNum, Integer pageSize) {

        String apiUrl = "/base/person/v2/queryPersonByOrgPageList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", pageNum);
        queryParam.put("pageSize", pageSize);
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            return rows.toJavaList(XiaoShiPersonVO.class);
        }
        return null;
    }

    @Override
    public String add(WorkRecordVO vo) {

        /**
         * 推送人员信息：
         *      1.1推送图片，获取faceTokens(图片唯一标识(list))
         *      1.2根据projectId获取默认groupId（分组）
         *      1.3封装起来推送
         *      1.4返回推送后获取的personId
         *
         */
        XiaoShiPersonVO xiaoShiPersonVO = new XiaoShiPersonVO();

        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(),null,null,null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        }
        /**
         * 1.1获取图片唯一标识
         */
        //图片类型：1-jpg，2-png
        String suffix = fileIdRef.get(vo.getId()).getFileName().substring(fileIdRef.get(vo.getId()).getFileName().lastIndexOf(".") + 1);
        XiaoShiPersonPicVO xiaoShiPersonPicVO = pushPersonPic(fileIdRef.get(vo.getId()).getId(), "jpg".equals(suffix) ? 1 : 2);
        List<XiaoShiPersonPicVO> personPicVOS = new ArrayList<>();
        personPicVOS.add(xiaoShiPersonPicVO);
        /**
         * 1.2获取默认regionId（位置）、groupId（分组）
         */

        PorjectEntity projectEntity = projectService.selectById(vo.getProjectId());
        List<String> groupIds = new ArrayList<>();
        groupIds.add(projectEntity.getGroupId());
        xiaoShiPersonVO.setGroupIds(groupIds);
        /**
         * 1.3人员基本信息
         */

        xiaoShiPersonVO.setPersonName(vo.getName());
        //1-男 2-女 转化为第三方 1-男 0-女
        if(vo.getSex() != null){
            xiaoShiPersonVO.setSex(vo.getSex() == 1 ? vo.getSex() : 0);
        }
        xiaoShiPersonVO.setCardNo(vo.getIdCardNo());
        xiaoShiPersonVO.setPhone(vo.getPhone());
        xiaoShiPersonVO.setPersonCode(vo.getId().toString());
        xiaoShiPersonVO.setFaceTokens(personPicVOS);
        /**
         * 发送请求
         */
        String apiUrl = "/base/person/v2/add";

        String personJSONString = JSONObject.toJSONString(xiaoShiPersonVO);
        JSONObject queryParam = JSONObject.parseObject(personJSONString);

        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        return resData.getString("personId");
    }

    @Override
    public void update(String personId) {

    }


    private XiaoShiPersonPicVO pushPersonPic(Long fileId, Integer imageType) {

        /**
         * 获取服务器中图片
         */
        Response response = attachmentApi.downloadFileById(fileId);
        try {
            /**
             * 转化为base64编码
             */
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray(inputStream);
            String image = Base64.getEncoder().encodeToString(bytes);

            /**
             * 发送图片获取图片唯一标识faceToken
             */
            String apiUrl = "/base/person/v1/imageUpload";
            JSONObject queryParam = new JSONObject();
            queryParam.put("image", image);
            queryParam.put("imageType", imageType);

            JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
            return resData.toJavaObject(XiaoShiPersonPicVO.class);

        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }


    @Override
    public void synPerson() {
        /**
         * 循环调用接口查询，将查询结果保存到数据库，
         * 根据sourceId判断，如果有则更新，无则插入；
         */
        boolean flag = true;
        Integer pageNum = 1;
        Integer pageSize = 50;
        int synNum = 0;//同步次数
        List<String> sourceIds = personService.list().stream().map(XiaoShiPersonEntity::getPersonId).collect(Collectors.toList());
        Map<String, Long> refMap = personService.list().stream().collect(Collectors.toMap(XiaoShiPersonEntity::getPersonId, XiaoShiPersonEntity::getId));
        while (flag) {
            List<XiaoShiPersonVO> personPage = getPage(pageNum, pageSize);
            if (ListUtil.isEmpty(personPage)) {
                flag = false;
            } else {
                for (XiaoShiPersonVO xiaoShiPersonVO : personPage) {
                    if (sourceIds.contains(xiaoShiPersonVO.getPersonId())) {
                        xiaoShiPersonVO.setId(refMap.get(xiaoShiPersonVO.getPersonId()));
                    }
                }
                boolean b = personService.saveOrUpdateBatch(BeanMapper.mapList(personPage, XiaoShiPersonEntity.class));
                if (b) {
                    synNum++;
                    pageNum++;
                }
                if (personPage.size() != pageSize) {
                    flag = false;
                }

            }
        }
        logger.info("同步成功,共同步" + synNum + "次,每次50条数据");
    }
}
