package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 小视接口公用api
 *
 * @author generator
 */
@Service("XiaoShiPublicApiService")
public class XiaoShiPublicApiServiceImpl implements XiaoShiPublicApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IXiaoShiEquipService equipService;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private CacheManager cacheManager;

    private static String appKey = "94988e1a478141959da73bce47ecf82c";
    private static String appSecret = "c57ef88f400f4bb7ac91ed5ccd937c24";
    private static String baseUrl = "https://am-api.minivision.cn/openApi";//v2.4.8.8

    @Override
    public JSONObject getAuthorToken() {


        Long timestamp = System.currentTimeMillis();
        JSONObject redisToken = cacheManager.get("xiaoshi::authorToken::" + appKey);
        /**
         * 获取AutohorToken必要参数，默认5分钟有效期
         */
        if (redisToken != null) {
            return redisToken;
        } else {
            String signature = "";
            try {
                signature = org.springframework.util.DigestUtils.md5DigestAsHex((appKey + appSecret + timestamp).getBytes("utf-8"));

            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            JSONObject queryParam = new JSONObject();
            queryParam.put("appKey", appKey);
            queryParam.put("timestamp", timestamp);
            queryParam.put("signature", signature);
            logger.info("获取AuthorToken发送参数{}", queryParam.toJSONString());
            JSONObject resData = sendPostRequestNoAuth("/adm/common/v1/token", queryParam);
            logger.info("接收AuthorToken结果为{}", resData.toJSONString());


            String token = resData.getString("token");
            JSONObject authorToken = new JSONObject();
            authorToken.put("token", token);
            authorToken.put("appKey", appKey);
            cacheManager.setex("xiaoshi::authorToken::" + appKey, authorToken, 60 * 60);
            return authorToken;
        }


    }


    /**
     * 发送请求方法获取token
     *
     * @param queryUrl   查询接口地址
     * @param queryParam 查询参数
     * @return
     */
    @Override
    public JSONObject sendPostRequestNoAuth(String queryUrl, JSONObject queryParam) {
        try {
            logger.info("查询业务api为" + queryUrl);
            logger.info("查询业务参数为" + queryParam.toJSONString());

            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");

            // 在Header中添加参数
//            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());

            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用接口查询结果为{}", response.toString());
                return handelResJSON(JSONObject.parseObject(response.toString()));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 业务通用发送请求方法
     *
     * @param queryUrl   查询接口地址
     * @param queryParam 查询参数
     * @return
     */
    @Override
    public JSONObject sendPostRequest(String queryUrl, JSONObject queryParam) {
        try {
            logger.info("查询业务api为" + queryUrl);
            logger.info("查询业务参数为" + queryParam.toJSONString());

            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            JSONObject authorToken = getAuthorToken();
            /**
             * header中添加必要的token信息
             */
            connection.setRequestProperty("appKey", authorToken.get("appKey").toString());
            connection.setRequestProperty("token", authorToken.get("token").toString());
            // 在Header中添加参数
//            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());

            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用接口查询结果为{}", response.toString());
                return handelResJSON(JSONObject.parseObject(response.toString()));
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 处理返回结果
     *
     * @param resJSON
     * @return
     */
    private JSONObject handelResJSON(JSONObject resJSON) {
        if (resJSON == null) {
            throw new BusinessException("小视科技网络异常，无法建立连接，请稍后再试！");
        }
        String resCode = resJSON.getString("resCode");
        JSONArray resMsg = resJSON.getJSONArray("resMsg");
        JSONObject resData = resJSON.getJSONObject("resData");
        if (!"1".equals(resCode)) {
            throw new BusinessException("错误代码：[" + resMsg.getString(0) + "]");
        }
        return resData;
    }
}
