/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.mapper.WorkerEnterMapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IFaceService;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPersonApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="workerEnterService")
public class WorkerEnterServiceImpl
extends BaseServiceImpl<WorkerEnterMapper, WorkerEnterEntity>
implements IWorkerEnterService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RECORD_BILL_TYPE = "BT202211000002";
    private static final String ENTER_BILL_TYPE = "BT202211000003";
    private static final String WORKER_BILL_TYPE = "BT202211000007";
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";
    private static final String IDBACK_TYPE = "idCardBack";
    private static final String FACE_TYPE = "face";
    private static final String ORDER_TYPE = "desc";
    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";
    private static final String RECORD_CON_SOURCE_TYPE = "workRecord001";
    private static final String ENTER_CON_SOURCE_TYPE = "wokerEnter002";
    private static final String BILL_CODE = "LABOR_WORKER_ENTER";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPorjectService porjectService;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IWorkerService workerService;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Resource
    private IFaceService faceService;
    @Autowired
    private IAttendanceService attachmentService;
    @Autowired
    private XiaoShiPersonApiService personApiService;

    @Override
    public WorkerEnterVO saveOrUpdate(WorkerEnterVO saveOrUpdateVO) {
        WorkerEnterEntity entity = (WorkerEnterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkerEnterEntity.class));
        if (entity.getWorkType() != null && entity.getWorkType().isEmpty()) {
            entity.setWorkType(null);
            entity.setWorkTypeName(null);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getSourceFlag() == 1) {
                entity.setSourceFlagName("\u81ea\u5236");
            }
            if (entity.getSourceFlag() == 2) {
                entity.setSourceFlagName("\u516c\u53f8\u82b1\u540d\u518c");
            }
            if (entity.getSourceFlag() == 3) {
                entity.setSourceFlagName("\u9080\u8bf7");
            }
            if (entity.getIdCardFrontPhotoFlag() == null) {
                entity.setIdCardFrontPhotoFlag(2);
            }
            if (entity.getFacePhotoFlag() == null) {
                entity.setFacePhotoFlag(2);
            }
            entity.setChangeState(0);
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setChangeVersion(1);
        }
        super.saveOrUpdate((Object)entity, false);
        WorkerEnterVO vo = (WorkerEnterVO)BeanMapper.map((Object)((Object)entity), WorkerEnterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> saveCheck(WorkerEnterVO vo) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)vo.getPhone())) {
            QueryWrapper queryEnter = new QueryWrapper();
            queryEnter.eq((Object)"phone", (Object)vo.getPhone());
            queryEnter.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            queryEnter.eq((Object)"dr", (Object)0);
            if (vo.getId() != null) {
                queryEnter.ne((Object)"id", (Object)vo.getId());
            }
            queryEnter.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list1 = super.list((Wrapper)queryEnter);
            if (list1.size() > 0) {
                jsonObject.put("level", (Object)0);
                jsonObject.put("msg", (Object)("\u8be5\u624b\u673a\u53f7\u88ab\u8fdb\u573a\u8bb0\u5f55\u3010" + ((WorkerEnterEntity)((Object)list1.get(0))).getName() + "\u3011\u6ce8\u518c\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0!"));
                return CommonResponse.success((Object)jsonObject);
            }
            QueryWrapper recordOneByPhone = new QueryWrapper();
            recordOneByPhone.eq((Object)"phone", (Object)vo.getPhone());
            recordOneByPhone.eq((Object)"dr", (Object)0);
            recordOneByPhone.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            List list = this.workerService.list((Wrapper)recordOneByPhone);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                jsonObject.put("level", (Object)0);
                jsonObject.put("msg", (Object)("\u8be5\u624b\u673a\u53f7\u88ab\u516c\u53f8\u82b1\u540d\u518c\u3010" + ((WorkerEntity)((Object)list.get(0))).getName() + "\u3011\u6ce8\u518c\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\uff1b"));
                return CommonResponse.success((Object)jsonObject);
            }
        }
        QueryWrapper queryRecordCard = new QueryWrapper();
        queryRecordCard.eq((Object)"id_card", (Object)vo.getIdCard());
        queryRecordCard.eq((Object)"enter_exit_state", (Object)1);
        queryRecordCard.eq((Object)"project_id", (Object)vo.getProjectId());
        queryRecordCard.eq((Object)"last_flag", (Object)1);
        queryRecordCard.eq((Object)"dr", (Object)0);
        queryRecordCard.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List list2 = this.recordService.list((Wrapper)queryRecordCard);
        if (list2.size() > 0) {
            jsonObject.put("level", (Object)0);
            jsonObject.put("msg", (Object)"\u8be5\u52b3\u52a1\u4eba\u5458\u5df2\u5728\u573a\uff0c\u4e0d\u80fd\u91cd\u590d\u8fdb\u573a");
            return CommonResponse.success((Object)jsonObject);
        }
        QueryWrapper queryEnterByCard = new QueryWrapper();
        queryEnterByCard.eq((Object)"id_card", (Object)vo.getIdCard());
        queryEnterByCard.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (vo.getId() != null) {
            queryEnterByCard.ne((Object)"id", (Object)vo.getId());
        }
        queryEnterByCard.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list3 = super.list((Wrapper)queryEnterByCard);
        if (list3.size() > 0) {
            jsonObject.put("level", (Object)0);
            jsonObject.put("msg", (Object)("\u8be5\u4eba\u5458\u5728\u3010" + ((WorkerEnterEntity)((Object)list3.get(0))).getProjectName() + "\u3011\u4e2d\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8fdb\u573a\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u4e0a\u6b21\u8fdb\u573a\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u672c\u6b21\u8fdb\u573a\uff1b"));
            return CommonResponse.success((Object)jsonObject);
        }
        WorkerEntity recordOneByCard = this.workerService.queryOneByIdCard(vo.getIdCard());
        if (recordOneByCard != null) {
            jsonObject.put("level", (Object)1);
            jsonObject.put("msg", (Object)"\u8be5\u7528\u6237\u5728\u53f8\u82b1\u540d\u518c\u4e2d\u5df2\u5b58\u5728\uff0c\u672c\u6b21\u8fdb\u573a\u5c06\u4f1a\u4fee\u6539\u516c\u53f8\u82b1\u540d\u518c\u4e2d\u8be5\u4eba\u5458\u7684\u57fa\u672c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u5b9a\uff1f");
            return CommonResponse.success((Object)jsonObject);
        }
        jsonObject.put("level", (Object)2);
        return CommonResponse.success((Object)jsonObject);
    }

    @Override
    public void bpmWriteBackAndInsert(WorkerEnterEntity entity) {
        boolean recordFlage = true;
        WorkerEntity recordOneByCard = this.workerService.queryOneByIdCard(entity.getIdCard());
        WorkerVO newWorker = (WorkerVO)BeanMapper.map((Object)((Object)entity), WorkerVO.class);
        if (null != recordOneByCard) {
            newWorker = (WorkerVO)BeanMapper.map((Object)((Object)recordOneByCard), WorkerVO.class);
            newWorker.setLastProjectId(entity.getProjectId());
            if (null != entity.getName()) {
                newWorker.setName(entity.getName());
            }
            if (null != entity.getPhone()) {
                newWorker.setPhone(entity.getPhone());
            }
            if (null != entity.getSex()) {
                newWorker.setSex(entity.getSex());
            }
            if (null != entity.getBirthDate()) {
                newWorker.setBirthDate(entity.getBirthDate());
            }
            if (null != entity.getNation()) {
                newWorker.setNation(entity.getNation());
            }
            if (null != entity.getWorkType()) {
                newWorker.setWorkType(entity.getWorkType());
            }
            if (null != entity.getWorkTypeName()) {
                newWorker.setWorkTypeName(entity.getWorkTypeName());
            }
            if (null != entity.getBankName()) {
                newWorker.setBankName(entity.getBankName());
            }
            if (null != entity.getBankAccount()) {
                newWorker.setBankAccount(entity.getBankAccount());
            }
            if (null != entity.getWagesType()) {
                newWorker.setWagesType(entity.getWagesType());
            }
            if (null != entity.getWagesTypeName()) {
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (null != entity.getWage()) {
                newWorker.setWage(entity.getWage());
            }
            if (null != entity.getOvertimeWage()) {
                newWorker.setOvertimeWage(entity.getOvertimeWage());
            }
            if (null != entity.getProvince()) {
                newWorker.setProvince(entity.getProvince());
            }
            if (null != entity.getCity()) {
                newWorker.setCity(entity.getCity());
            }
            if (null != entity.getArea()) {
                newWorker.setArea(entity.getArea());
            }
            if (null != entity.getAddress()) {
                newWorker.setAddress(entity.getAddress());
            }
            if (null != entity.getWagesTypeName()) {
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (null != entity.getMemo()) {
                newWorker.setMemo(entity.getMemo());
            }
            if (null != entity.getIdCardFrontPhotoFlag()) {
                newWorker.setIdCardFrontPhotoFlag(entity.getIdCardFrontPhotoFlag());
            }
            if (null != entity.getIdCardBackPhotoFlag()) {
                newWorker.setIdCardBackPhotoFlag(entity.getIdCardBackPhotoFlag());
            }
            if (null != entity.getFacePhotoFlag()) {
                newWorker.setFacePhotoFlag(entity.getFacePhotoFlag());
            }
            if (null != entity.getIdCardName()) {
                newWorker.setIdCardName(entity.getIdCardName());
            }
            if (null != entity.getIdCardNo()) {
                newWorker.setIdCardNo(entity.getIdCardNo());
            }
            if (null != entity.getIdCardSex()) {
                newWorker.setIdCardSex(entity.getIdCardSex());
            }
            if (null != entity.getIdCardBirthDate()) {
                newWorker.setIdCardBirthDate(entity.getIdCardBirthDate());
            }
            if (null != entity.getIdCardNation()) {
                newWorker.setIdCardNation(entity.getIdCardNation());
            }
            if (null != entity.getIdCardStartDate()) {
                newWorker.setIdCardStartDate(entity.getIdCardStartDate());
            }
            if (null != entity.getIdCardEndDate()) {
                newWorker.setIdCardEndDate(entity.getIdCardEndDate());
            }
            if (null != entity.getIdCardIssue()) {
                newWorker.setIdCardIssue(entity.getIdCardIssue());
            }
            if (null != entity.getIdCardBackPhotoExceptional()) {
                newWorker.setIdCardBackPhotoExceptional(entity.getIdCardBackPhotoExceptional());
            }
            if (null != entity.getIdCardFrontPhotoExceptional()) {
                newWorker.setIdCardFrontPhotoExceptional(entity.getIdCardFrontPhotoExceptional());
            }
            if (null != entity.getFacePhotoExceptional()) {
                newWorker.setFacePhotoExceptional(entity.getFacePhotoExceptional());
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)entity.getTeamId())) {
                List<String> teamIdS = Arrays.asList(entity.getTeamId().split(","));
                LambdaQueryWrapper teamLambda = new LambdaQueryWrapper();
                teamLambda.in(BaseEntity::getId, teamIdS);
                List list = this.orgTeamService.list((Wrapper)teamLambda);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    String newTeamIdS = list.stream().map(BaseEntity::getId).collect(Collectors.toList()).stream().map(Objects::toString).collect(Collectors.joining(","));
                    String newTeamNames = list.stream().map(OrgTeamEntity::getName).collect(Collectors.toList()).stream().map(Objects::toString).collect(Collectors.joining(","));
                    newWorker.setTeamId(newTeamIdS);
                    newWorker.setTeamName(newTeamNames);
                } else {
                    newWorker.setTeamId(null);
                    newWorker.setTeamName(null);
                }
            }
            newWorker.setId(null);
            newWorker.setSourceFlag(Integer.valueOf(2));
            newWorker.setSourceFlagName("\u9879\u76ee\u8fdb\u573a");
            newWorker.setSourceProjectId(entity.getProjectId());
            newWorker.setLastProjectId(entity.getProjectId());
        }
        newWorker.setEnabled(Integer.valueOf(1));
        newWorker.setWorkState(Integer.valueOf(1));
        newWorker.setWorkStateName("\u5df2\u5165\u573a");
        WorkerVO workerVO = this.workerService.insertOrUpdate(newWorker);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s : typeList) {
            CommonResponse deleteFileByParam;
            CommonResponse idCardResponse = this.attachmentApi.queryListBySourceId(entity.getId(), ENTER_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u8bbf\u95ee\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (!CollectionUtils.isNotEmpty((Collection)((Collection)idCardResponse.getData()))) continue;
            CommonResponse orgIdCardResponse = this.attachmentApi.queryListBySourceId(workerVO.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (!orgIdCardResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgIdCardResponse.getData())) && !(deleteFileByParam = this.attachmentApi.deleteFileByParam(workerVO.getId(), WORKER_BILL_TYPE, s)).isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u5220\u9664\u5931\u8d25");
            }
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(Long.toString(entity.getId()), ENTER_BILL_TYPE, s, Long.toString(workerVO.getId()), WORKER_BILL_TYPE, s);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u590d\u5236\u5931\u8d25");
            }
            CommonResponse orgIdCardNewResponse = this.attachmentApi.queryListBySourceId(workerVO.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (!orgIdCardNewResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (!FACE_TYPE.equals(s) || !CollectionUtils.isNotEmpty((Collection)((Collection)orgIdCardNewResponse.getData()))) continue;
            AttachmentVO attachmentVO = (AttachmentVO)((List)orgIdCardNewResponse.getData()).get(0);
            FaceInfoVO faceInfoVO = new FaceInfoVO();
            faceInfoVO.setUserId(workerVO.getId());
            faceInfoVO.setUserName(workerVO.getName());
            faceInfoVO.setIdNumber(workerVO.getIdCard());
            faceInfoVO.setImgUrl(this.fileUrl + attachmentVO.getFilePath());
            this.faceService.faceRegistration(faceInfoVO, false);
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkRecordEntity::getSourceId, (Object)entity.getId());
        List recordList = this.recordService.list((Wrapper)lambdaQuery);
        WorkRecordVO record = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        record.setId(Long.valueOf(CollectionUtils.isNotEmpty((Collection)recordList) ? ((WorkRecordEntity)((Object)recordList.get(0))).getId() : IdWorker.getId()));
        record.setWorkerId(workerVO.getId());
        record.setProjectTeamId(entity.getTeamId());
        record.setProjectTeamName(entity.getTeamName());
        record.setProjectWorkType(entity.getWorkType());
        record.setProjectWorkTypeName(entity.getWorkTypeName());
        record.setSourceFlag(Integer.valueOf(1));
        record.setSourceFlagName("\u9879\u76ee\u8fdb\u573a");
        record.setSourceId(entity.getId());
        record.setEnterExitState(Integer.valueOf(1));
        record.setSubContractId(entity.getSubContractId());
        record.setSubContractName(entity.getSubContractName());
        record.setSupplierId(entity.getSupplierId());
        record.setSupplierName(entity.getSupplierName());
        record.setEnterDate(entity.getEnterDate());
        record.setEmployeeId(entity.getEmployeeId());
        record.setEmployeeName(entity.getEmployeeName());
        record.setProjectId(entity.getProjectId());
        record.setProjectName(entity.getProjectName());
        record.setOrgId(entity.getOrgId());
        record.setParentOrgId(entity.getParentOrgId());
        record.setParentOrgName(entity.getParentOrgName());
        String personId = this.personApiService.add(record);
        record.setPersonId(personId);
        ArrayList<WorkRecordVO> saveVoList = new ArrayList<WorkRecordVO>();
        saveVoList.add(record);
        List<WorkRecordVO> recordVOS = this.recordService.insertWorkRecord(saveVoList);
        WorkRecordVO recordVO = recordVOS.get(0);
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(Long.toString(entity.getId()), ENTER_BILL_TYPE, ENTER_CON_SOURCE_TYPE, Long.toString(recordVO.getId()), RECORD_BILL_TYPE, RECORD_CON_SOURCE_TYPE);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u590d\u5236\u5931\u8d25");
        }
    }

    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return ((WorkerEnterMapper)this.baseMapper).updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }

    @Override
    public CommonResponse<JSONObject> topWorkRecord(FilterOrgIdVo filterOrgId) {
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
        QueryWrapper porjectyQueryWrapper = new QueryWrapper();
        List projectList = this.porjectService.list((Wrapper)porjectyQueryWrapper);
        List projectOrgIds = projectList.stream().map(PorjectEntity::getOrgId).collect(Collectors.toList());
        JSONObject jsonObject = new JSONObject();
        LinkedHashMap<String, Long> top15 = new LinkedHashMap<String, Long>(15);
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd");
        Calendar cal = Calendar.getInstance();
        top15.put(formatter.format(cal.getTime()), 0L);
        for (int i = 0; i < 14; ++i) {
            cal.add(5, -1);
            Date day = cal.getTime();
            top15.put(formatter.format(day), 0L);
        }
        if (ListUtil.isEmpty(projectOrgIds)) {
            jsonObject.put("workNum", (Object)0);
            jsonObject.put("attendanceDays", (Object)0);
            jsonObject.put("top15", top15);
            return CommonResponse.success((Object)jsonObject);
        }
        LambdaQueryWrapper workNumLambda = new LambdaQueryWrapper();
        workNumLambda.in(WorkRecordEntity::getOrgId, projectOrgIds);
        workNumLambda.eq(WorkRecordEntity::getEnterExitState, (Object)1);
        workNumLambda.eq(WorkRecordEntity::getLastFlag, (Object)1);
        List list = this.recordService.list((Wrapper)workNumLambda);
        int workNum = list.size();
        jsonObject.put("workNum", (Object)workNum);
        String orgIdS = "(" + String.join((CharSequence)",", projectOrgIds.stream().map(Object::toString).collect(Collectors.toList())) + ")";
        Integer integer = this.attachmentService.queryAttendanceOrgIds(orgIdS);
        jsonObject.put("attendanceDays", (Object)integer);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("in", projectOrgIds));
        queryParam.getParams().put("", new Parameter("sql", (Object)" punch_card_date >= DATE_SUB(NOW(),INTERVAL 15 DAY)"));
        queryParam.getOrderMap().put("punch_card_date", ORDER_TYPE);
        List attendanceEntities = this.attachmentService.queryList(queryParam);
        Map<String, Long> collect1 = attendanceEntities.stream().collect(Collectors.groupingBy(e -> formatter.format(e.getPunchCardDate()), Collectors.counting()));
        for (String s : top15.keySet()) {
            if (collect1.get(s) == null) {
                top15.put(s, 0L);
                continue;
            }
            top15.put(s, collect1.get(s));
        }
        jsonObject.put("top15", top15);
        return CommonResponse.success((Object)jsonObject);
    }
}

