package com.ejianc.business.other.henger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.henger.vo.HengErRecordVO;
import com.ejianc.business.other.henger.vo.HengErTaskVO;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiLogEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiLogService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 恒尔-识别记录
 *
 * @author generator
 */
@Controller
@RequestMapping("hengErApi/records")
public class HengErRecordsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IHengErTaskService hengErTaskService;
    @Autowired
    private IAttendanceLogService attendanceLogService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IXiaoShiLogService xiaoShiLogService;

    @RequestMapping(value = "/heartBeat", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject heartBeat(@RequestBody JSONObject json) {
        logger.info("心跳接受成功-------------------{}", json.toJSONString());
        JSONObject returnJsonObject = new JSONObject();

        /**
         *
         * 数据校验：
         *
         * 数据格式如下:
         * 2023年12月28日12:15:34
         * {
         * 	"data": {
         * 		"TaskId": 5,
         * 		"StateCode": 0,
         * 		"OperatorInfo": {
         * 			"operator": "AddPerson",
         * 			"SuccessCount": 1,
         * 			"ProgressText": "1/1",
         * 			"ErrCount": 0,
         * 			"errorInfo": [{
         * 				"errorcode": 0,
         * 				"errorItem": "",
         * 				"errordesc": ""
         *                        }],
         * 			"SuccessInfo": []* 		}
         * 	},
         * 	"operator": "HeartBeat",
         * 	"info": {
         * 		"DeviceID": 2369912,
         * 		"Time": "2023-12-27T17:26:38"
         * 	}
         * }
         */
        JSONObject info = json.getJSONObject("info");
        JSONObject data = json.getJSONObject("data");
        String operator = json.getString("operator");

        if(info == null || data == null || operator == null){
            throw new BusinessException("协议格式不正确！");
        }
        if(data.get("TaskId") == null || data.get("StateCode") == null || data.get("OperatorInfo") == null){
            throw new BusinessException("指令数据异常！");
        }

        Integer deviceID = info.getInteger("DeviceID");
        Integer taskId = data.getInteger("TaskId");
        Integer stateCode = data.getInteger("StateCode");

        /**
         * 如果设备空闲，发送最新指令,回填发送时间
         */
        if (stateCode == 0) {

            QueryWrapper<HengErTaskEntity> taskWrapper = new QueryWrapper<>();
            taskWrapper.eq("equip_sn", deviceID.toString());
            taskWrapper.ne("finish_flag", 1);
            taskWrapper.orderByAsc("service_date");
            taskWrapper.last("limit 1");
            List<HengErTaskEntity> hengErTaskEntities = hengErTaskService.list(taskWrapper);

            if(ListUtil.isNotEmpty(hengErTaskEntities)){
                HengErTaskEntity hengErTaskEntity = hengErTaskEntities.get(0);
                String queryParam = hengErTaskEntity.getQueryParam();
                JSONObject operatorInfo = JSONObject.parseObject(queryParam);
                returnJsonObject.put("TimeStamp", new Date().getTime());
                returnJsonObject.put("TaskId", hengErTaskEntity.getTaskId());
                returnJsonObject.put("OperatorInfo", operatorInfo);

                /**
                 * 回填任务发送时间
                 */
                hengErTaskEntity.setSendDate(new Date());
                hengErTaskService.updateById(hengErTaskEntity);
            }


            /**
             * 如果无错误信息，并且任务执行完成，回填任务队列状态。
             */
            if(data.get("OperatorInfo") != null){
                //TODO 任务队列回填
                JSONObject operatorInfo = data.getJSONObject("OperatorInfo");
//                if(operatorInfo.get("errorInfo") != null){
//                    JSONObject errorInfo = data.getJSONObject("errorInfo");
//                    if(errorInfo.get("errorcode") != null){
//                        Integer errorCode = errorInfo.getInteger("errorcode");
//                        if(errorCode == 0){
//                            hengErTaskService.update(Wrappers.<HengErTaskEntity>lambdaUpdate()
//                                    .set(HengErTaskEntity::getFinishFlag,"1")
//                                    .set(HengErTaskEntity::getReturnDate,new Date())
//                                    .eq(HengErTaskEntity::getEquipSn,deviceID)
//                                    .eq(HengErTaskEntity::getTaskId,taskId)
//                            );
//                            logger.info("任务执行完成，taskId = {}",taskId);
//                        }
//                    }
//                }
                if(operatorInfo.get("ErrCount") != null){
                    String errCount = operatorInfo.getString("ErrCount");
                    if(errCount.equals("0")){
                        hengErTaskService.update(Wrappers.<HengErTaskEntity>lambdaUpdate()
                                .set(HengErTaskEntity::getFinishFlag,"1")
                                .set(HengErTaskEntity::getReturnDate,new Date())
                                .eq(HengErTaskEntity::getEquipSn,deviceID)
                                .eq(HengErTaskEntity::getTaskId,taskId)
                        );
                        logger.info("任务执行完成，taskId = {}",taskId);
                    } else {
                        logger.info("任务返回出现错误，taskId = {}",taskId);

                    }

                }
            }


        }

        /**
         * 回写日志
         */
        XiaoShiLogEntity xiaoShiLogEntity = new XiaoShiLogEntity();
        xiaoShiLogEntity.setInputParams(returnJsonObject.toJSONString());
        xiaoShiLogEntity.setResData(json.toJSONString());
        xiaoShiLogEntity.setCreateTime(new Date());
        xiaoShiLogService.saveOrUpdate(xiaoShiLogEntity);
        /**
         * 回写设备状态
         */
        if (data.getInteger("StateCode") != null){
            hengErEquipService.update(Wrappers.<HengErEquipEntity>lambdaUpdate()
                    .set(HengErEquipEntity::getEquipStatus,data.getInteger("StateCode"))
                    .set(HengErEquipEntity::getEquipDate,new Date())
                    .eq(HengErEquipEntity::getEquipSn,deviceID.toString())
                    .in(HengErEquipEntity::getBillState, Arrays.asList(1,3))
            );
            logger.info("同步设备信息成功!");
        }


        logger.info("心跳返回数据为{}",returnJsonObject.toJSONString());
        return returnJsonObject;
    }

    @RequestMapping(value = "/realTimeSyn", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject realTimeSyn(@RequestBody JSONObject json) {
        /**
         * 解析设备id和人员id，及识别时间
         */
        JSONObject info = json.getJSONObject("info");
        HengErRecordVO hengErRecordVO = info.toJavaObject(HengErRecordVO.class);
        String equipSn = hengErRecordVO.getDeviceID();
        Long workerId = hengErRecordVO.getPersonUUID();
        Date serviceDate = hengErRecordVO.getCreateTime();
        String verifyStatus = hengErRecordVO.getVerifyStatus();

        /**
         * 只处理允许访问的接口
         */
        if(verifyStatus.equals("1")){
            HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(equipSn);
            if(hengErEquipVO == null){
                throw new BusinessException("设备为空！");
            }
            String punchCardType = hengErEquipVO.getEnterType().equals("1")?"上班打卡":"下班打卡";
            attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(),punchCardType,serviceDate);
        }
        logger.info("认证结果接受成功-------------------{}", json.toJSONString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code",200);
        jsonObject.put("desc","OK");
        return jsonObject;
    }


}
