package com.ejianc.business.other.henger.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.henger.service.HengErPersonApiService;

import com.ejianc.business.other.henger.service.HengErPublicApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonPicVO;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 恒尔接口公用api
 *
 * @author generator
 */
@Service("HengErPersonApiService")
public class HengErPersonApiServiceImpl implements HengErPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private HengErPublicApiService hengErPublicApiService;

    @Override
    public void add(WorkRecordVO vo) {


        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (ListUtil.isEmpty(fileData)) {
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else {
            throw new BusinessException("访问文件服务异常!");
        }
        /**
         * 1.1获取图片唯一标识
         */
        AttachmentVO attachmentVO = fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        //图片类型：1-jpg，2-png
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = fileIdRef.get(vo.getId()).getId();
        String image = "";
        /**
         * 1.2获取服务器中图片,并转化为base64
         */
        Response response = attachmentApi.downloadFileById(fileId);
        try {
            /**
             * 转化为base64编码
             */
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray(inputStream);
            image = Base64.getEncoder().encodeToString(bytes);

        } catch (IOException e) {
            e.printStackTrace();
        }

        String apiUrl = "AddPerson";
        String ip = "172.16.105.14";
        String sn = "2369912";
        /**
         * 1.3人员基本信息
         */
        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        queryParam.put("operator", apiUrl);

        infoDetail.put("DeviceID", sn);
        infoDetail.put("PersonUUID", vo.getWorkerId());
//        infoDetail.put("PersonType", 0);
        infoDetail.put("Name", vo.getName());
        if (vo.getSex() != null) {
            //1-男 2-女 转化为第三方 0-男 1-女
            infoDetail.put("Gender", vo.getSex() == 1 ? 0 : 1);
        }
        infoDetail.put("CardType", 0);
        infoDetail.put("IdCard", vo.getIdCardNo());
        infoDetail.put("Telnum", vo.getPhone());


        queryParam.put("info", infoDetail);
//        queryParam.put("picinfo", image);
        String url = "http://csqlh.zzyjjt.com/" + fileIdRef.get(vo.getId()).getFilePath();
        queryParam.put("picURI", url);
        JSONObject jsonObject = hengErPublicApiService.sendPostRequest(ip, apiUrl, queryParam);

    }

    @Override
    public JSONObject getAddCom(WorkRecordVO vo,String equipSn) {
        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if (ListUtil.isEmpty(fileData)) {
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else {
            throw new BusinessException("访问文件服务异常!");
        }
        /**
         * 1.1获取图片地址
         */
        AttachmentVO attachmentVO = fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        //图片类型：1-jpg，2-png
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        Long fileId = fileIdRef.get(vo.getId()).getId();
        String image = "";
        String url = "http://csqlh.zzyjjt.com/" + fileIdRef.get(vo.getId()).getFilePath();

        /**
         * 1.2人员基本信息
         */
        JSONObject queryParam = new JSONObject(new LinkedHashMap<>());
        JSONObject infoDetail = new JSONObject();

        String apiUrl = "AddPerson";
        queryParam.put("operator", apiUrl);

        infoDetail.put("DeviceID", equipSn);
        infoDetail.put("PersonUUID", vo.getWorkerId());
//        infoDetail.put("PersonType", 0);
        infoDetail.put("Name", vo.getName());
        if (vo.getSex() != null) {
            //1-男 2-女 转化为第三方 0-男 1-女
            infoDetail.put("Gender", vo.getSex() == 1 ? 0 : 1);
        }
        infoDetail.put("CardType", 0);
        infoDetail.put("IdCard", vo.getIdCardNo());
        infoDetail.put("Telnum", vo.getPhone());
        infoDetail.put("picURI", url);

        queryParam.put("info", infoDetail);
//        queryParam.put("picinfo", image);

        return queryParam;
    }
}
