package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.yufan.service.YuFanEquipApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 宇泛设备接口api
 *
 * @author generator
 */
@Service("YuFanEquipApiService")
public class YuFanEquipApiServiceImpl implements YuFanEquipApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

//    @Autowired
//    private IXiaoShiEquipService equipService;
    @Autowired
    private YuFanPublicApiService publicApiService;

    @Override
    public JSONArray getEquipPage(Integer pageNum, Integer pageSize) {

        String apiUrl = "/v2/device/page";
        JSONObject queryParam = new JSONObject();
        queryParam.put("index", pageNum);
        queryParam.put("pageSize", pageSize);
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {

            JSONArray content = resData.getJSONArray("content");
            logger.info("转换数据为"+content);
//            return rows.toJavaList(XiaoShiEquipVO.class);
            return content;
        }
        return null;
    }

    @Override
    public JSONArray addEquip(HengErEquipEntity hengErEquipEntity) {
        String apiUrl = "/v2/device/create";
        JSONObject queryParam = new JSONObject();
        queryParam.put("name", hengErEquipEntity.getEquipName());
        queryParam.put("source", "000000");
        queryParam.put("deviceNo", hengErEquipEntity.getEquipSn());
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {

            JSONArray content = resData.getJSONArray("content");
            logger.info("转换数据为"+content);
//            return rows.toJavaList(XiaoShiEquipVO.class);
            return content;
        }


        return null;
    }
//    @Override
//    public void synEquip() {
//        /**
//         * 循环调用接口查询，将查询结果保存到数据库，
//         * 根据regionId判断，如果有则更新，无则插入；
//         */
//        boolean flag = true;
//        Integer pageNum = 1;
//        Integer pageSize = 50;
//        int synNum = 0;//同步次数
//        List<String> deviceSns = equipService.list().stream().map(XiaoShiEquipEntity::getDeviceSn).collect(Collectors.toList());
//        Map<String, Long> deviceSnRefMap = equipService.list().stream().collect(Collectors.toMap(XiaoShiEquipEntity::getDeviceSn, XiaoShiEquipEntity::getId));
//        while (flag) {
//            List<XiaoShiEquipVO> equipPage = getEquipPage(pageNum, pageSize);
//            if (ListUtil.isEmpty(equipPage)) {
//                flag = false;
//            } else {
//                for (XiaoShiEquipVO xiaoShiEquipVO : equipPage) {
//                    if (deviceSns.contains(xiaoShiEquipVO.getDeviceSn())) {
//                        xiaoShiEquipVO.setId(deviceSnRefMap.get(xiaoShiEquipVO.getDeviceSn()));
//                    }
//                }
//                boolean b = equipService.saveOrUpdateBatch(BeanMapper.mapList(equipPage, XiaoShiEquipEntity.class));
//                if(b){
//                    synNum++;
//                    pageNum++;
//                }
//                if(equipPage.size() != pageSize){
//                    flag = false;
//                }
//
//            }
//        }
//        logger.info("同步成功,共同步"+synNum+"次,每次50条数据");
//    }
}
