/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.business.other.yufan.service.YuFanPersonApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="YuFanPersonApiService")
public class YuFanPersonApiServiceImpl
implements YuFanPersonApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YuFanPublicApiService publicApiService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPorjectService projectService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IWorkRecordService workRecordService;

    @Override
    public List<XiaoShiPersonVO> getPage(Integer pageNum, Integer pageSize) {
        String apiUrl = "/base/person/v2/queryPersonByOrgPageList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", (Object)pageNum);
        queryParam.put("pageSize", (Object)pageSize);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            return rows.toJavaList(XiaoShiPersonVO.class);
        }
        return null;
    }

    @Override
    public String addOrUpdate(WorkRecordVO vo) {
        List fileData;
        JSONObject resData;
        String apiUrl;
        JSONObject queryParam;
        String admitGuid = vo.getSn();
        if (StringUtils.isEmpty((CharSequence)vo.getSn())) {
            queryParam = new JSONObject();
            queryParam.put("name", (Object)vo.getName());
            queryParam.put("phone", (Object)vo.getPhone());
            queryParam.put("idCardNo", (Object)vo.getIdCardNo());
            queryParam.put("admitGuid", (Object)vo.getSn());
            apiUrl = "/v2/admit/update";
            resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
            admitGuid = resData.getString("admitGuid");
        } else {
            queryParam = new JSONObject();
            queryParam.put("name", (Object)vo.getName());
            queryParam.put("phone", (Object)vo.getPhone());
            queryParam.put("idCardNo", (Object)vo.getIdCardNo());
            apiUrl = "/v2/admit/create";
            resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
            admitGuid = resData.getString("admitGuid");
        }
        this.workRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(WorkRecordEntity::getSn, (Object)admitGuid)).set(WorkRecordEntity::getSnDate, (Object)new Date())).eq(BaseEntity::getId, (Object)vo.getId()));
        Map<Object, Object> fileIdRef = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            fileData = (List)listCommonResponse.getData();
            if (ListUtil.isEmpty((List)fileData)) {
                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
            }
        } else {
            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
        }
        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        AttachmentVO attachmentVO = (AttachmentVO)fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        this.pushPersonPic(((AttachmentVO)fileIdRef.get(vo.getId())).getId(), "jpg".equals(suffix) ? 1 : 2, admitGuid);
        PorjectEntity entity = (PorjectEntity)((Object)this.projectService.selectById(vo.getProjectId()));
        List list = this.hengErEquipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(HengErEquipEntity::getProjectId, (Object)entity.getId())).in(HengErEquipEntity::getBillState, Arrays.asList(1, 3)));
        for (HengErEquipEntity hengErEquipEntity : list) {
            this.bindDeviceAndPerson(admitGuid, hengErEquipEntity.getEquipSn());
            this.bindDeviceAndPerson(admitGuid, hengErEquipEntity.getEquipSn());
        }
        return admitGuid;
    }

    @Override
    public void delete(List<Long> workIds) {
    }

    @Override
    public void update(String personId) {
    }

    @Override
    public boolean bindDeviceAndPerson(String admitGuid, String deviceNo) {
        String apiUrl = "/v2/auth/device";
        JSONObject queryParam = new JSONObject();
        queryParam.put("admitGuids", (Object)admitGuid);
        queryParam.put("deviceNo", (Object)deviceNo);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        return true;
    }

    @Override
    public boolean revokeDeviceAndPerson(String admitGuid, String deviceNo) {
        String apiUrl = "/v2/auth/device/revoke";
        JSONObject queryParam = new JSONObject();
        queryParam.put("admitGuids", (Object)admitGuid);
        queryParam.put("deviceNo", (Object)deviceNo);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        return true;
    }

    private boolean pushPersonPic(Long fileId, Integer imageType, String admitGuid) {
        Response response = this.attachmentApi.downloadFileById(fileId);
        try {
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String image = Base64.getEncoder().encodeToString(bytes);
            String apiUrl = "/v2/face/register";
            JSONObject queryParam = new JSONObject();
            queryParam.put("admitGuid", (Object)admitGuid);
            queryParam.put("base64", (Object)image);
            JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

