package com.ejianc.business.other.yufan.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.service.XiaoShiRecordsApiService;
import com.ejianc.business.other.yufan.service.YuFanEquipApiService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * @Author: jiang
 * @Date: 2023/12/13 16:42
 **/


@Controller
@RequestMapping("/yuFanShiApi/records")
public class YuFanRecordsApiController {

    @Autowired
    private YuFanEquipApiService yuFanEquipApiService;


    @RequestMapping(value = "/callBackEquipRecordData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> callBackEquipRecordData(JSONObject jsonObject) {
        yuFanEquipApiService.callBackEquipRecordData(jsonObject);
        return CommonResponse.success("调用宇泛识别回调接口成功！");
    }
}
