package com.ejianc.business.other.yufan.service.api;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.enums.ConTypeEnum;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.business.other.yufan.service.YuFanEquipApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 宇泛设备接口api
 *
 * @author generator
 */
@Service("YuFanEquipApiService")
public class YuFanEquipApiServiceImpl implements YuFanEquipApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private YuFanPublicApiService publicApiService;
    @Autowired
    private IEquipRecordsService equipRecordsService;
    @Autowired
    private IAttendanceLogService attendanceLogService;
    @Autowired
    private IWorkRecordService workRecordService;

    @Override
    public JSONArray getEquipPage(Integer pageNum, Integer pageSize) {

        String apiUrl = "/v2/device/page";
        JSONObject queryParam = new JSONObject();
        queryParam.put("index", pageNum);
        queryParam.put("pageSize", pageSize);
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {

            JSONArray content = resData.getJSONArray("content");
            logger.info("转换数据为"+content);
//            return rows.toJavaList(XiaoShiEquipVO.class);
            return content;
        }
        return null;
    }

    @Override
    public JSONArray addEquip(HengErEquipEntity hengErEquipEntity) {
        String apiUrl = "/v2/device/create";
        JSONObject queryParam = new JSONObject();
        queryParam.put("name", hengErEquipEntity.getEquipName());
        queryParam.put("source", "000000");
        queryParam.put("deviceNo", hengErEquipEntity.getEquipSn());
        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {

            JSONArray content = resData.getJSONArray("content");
            logger.info("转换数据为"+content);
//            return rows.toJavaList(XiaoShiEquipVO.class);
            return content;
        }


        return null;
    }

    @Override
    public JSONArray callBackEquipRecordData(JSONObject jsonObject) {
        logger.info("宇泛认证结果接受成功-------------------{}", jsonObject.toJSONString());



        /**
         * 1、生成设备识别记录
         * 2、生成打卡记录
         */
        JSONObject data = jsonObject.getJSONObject("eventMsg");
        String deviceNo = data.getString("deviceNo");//设备序列号
        String admitGuid = data.getString("admitGuid");//人员guid 或者STRANGERBABY

        //1、生成设备识别记录
        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceNo);

        equipRecordsEntity.setPersonSn(admitGuid);

        equipRecordsEntity.setWorkerName(data.getString("admitName"));//识别主体姓名

        long showTime = data.getLongValue("showTime");//识别记录时间戳
        Date serviceDate = new Date(showTime);
        equipRecordsEntity.setServiceDate(serviceDate);

        equipRecordsEntity.setEquipType(ConTypeEnum.宇泛.getStatus());

        int type = data.getIntValue("type");

        equipRecordsEntity.setRemark(type == 1?"比对成功":"比对失败");//人员比对结果,1:比对成功 2:比对失败

        equipRecordsService.saveOrUpdate(equipRecordsEntity);



        //2、生成打卡记录
        if (type == 1) {
            HengErEquipVO hengErEquipVO = hengErEquipService.selectByEquipSn(deviceNo);
            List<WorkRecordEntity> list = workRecordService.list(Wrappers.<WorkRecordEntity>lambdaQuery().eq(WorkRecordEntity::getSn, admitGuid));
            if (hengErEquipVO == null) {
                throw new BusinessException("宇泛设备为空！"+deviceNo);
            }
            if(ListUtil.isEmpty(list)){
                throw new BusinessException("宇泛人员为空！"+admitGuid);
            }
            String punchCardType = hengErEquipVO.getEnterType().equals("1") ? "上班打卡" : "下班打卡";
            attendanceLogService.synPunchCard(list.get(0).getId(), hengErEquipVO.getProjectId(), punchCardType, serviceDate);
        }

        return null;
    }
}
