/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.henger.service.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.henger.service.HengErPublicApiService;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiLogService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import jodd.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="HengErPublicApiService")
public class HengErPublicApiServiceImpl
implements HengErPublicApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IXiaoShiEquipService equipService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IXiaoShiLogService xiaoShiLogService;
    private static String User = "admin";
    private static String Pwd = "admin";
    private static String base = "http://";

    @Override
    public String getAuthorToken() {
        byte[] key = (User + ":" + Pwd).getBytes();
        return Base64.encodeToString((byte[])key);
    }

    @Override
    public JSONObject sendPostRequest(String ip, String apiUrl, JSONObject queryParam) {
        try {
            this.logger.info("\u8bbe\u5907ip\u4e3a" + apiUrl);
            this.logger.info("\u4e1a\u52a1api\u4e3a" + apiUrl);
            this.logger.info("\u53c2\u6570\u4e3a" + queryParam.toJSONString());
            URL url = new URL(base + ip + "/action/" + apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            String authorToken = this.getAuthorToken();
            connection.setRequestProperty("Authorization", "Basic " + authorToken);
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                this.logger.info("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c\u4e3a{}", (Object)response.toString());
                JSONObject baseResJSON = JSONObject.parseObject((String)response.toString());
                return this.handelResJSON(baseResJSON, url.toString());
            }
            this.logger.info("\u670d\u52a1\u5668\u672a\u54cd\u5e94" + responseCode);
            throw new BusinessException(Integer.valueOf(responseCode));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject handelResJSON(JSONObject resJSON, String queryUrl) {
        this.logger.info("\u5904\u7406\u67e5\u8be2\u7ed3\u679c");
        if (resJSON == null) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u65e0\u6cd5\u5efa\u7acb\u8fde\u63a5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        String operator = resJSON.getString("operator");
        String code = resJSON.getString("code");
        if (!code.equals("200")) {
            this.logger.info("\u8bf7\u6c42\u9519\u8bef\uff01" + code);
            throw new BusinessException("\u670d\u52a1\u5668\u8fd4\u56de" + code);
        }
        JSONObject info = resJSON.getJSONObject("info");
        return info;
    }

    @Override
    public JSONObject lowerCaseJsonObject(JSONObject jsonObject) {
        JSONObject lowerCaseJsonObject = new JSONObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String lowerCaseKey = ((String)entry.getKey()).substring(0, 1).toLowerCase() + ((String)entry.getKey()).substring(1);
            lowerCaseJsonObject.put(lowerCaseKey, entry.getValue());
        }
        return lowerCaseJsonObject;
    }
}

