/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service(value="YuFanPublicApiService")
public class YuFanPublicApiServiceImpl
implements YuFanPublicApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private CacheManager cacheManager;
    private static String baseUrl = "http://wo-api.uni-ubi.com/";
    private static String appId = "FC4227F440D34F7F8BEEDC34F6926103";
    private static String appKey = "1E835F6AD9234EA8827F46AEC534477B";
    private static String appSecret = "75AA26D0FA374BF88A426CD365BE55F3";

    @Override
    public JSONObject getAuthorToken() {
        JSONObject redisToken = (JSONObject)this.cacheManager.get("YuFan::authorToken::" + appKey);
        String sign = "";
        Long timestamp = System.currentTimeMillis();
        if (redisToken != null) {
            this.logger.info("\u73b0\u5b58AuthorToken\u7ed3\u679c\u4e3a{}", (Object)redisToken);
            return redisToken;
        }
        try {
            sign = DigestUtils.md5DigestAsHex((byte[])(appKey + timestamp + appSecret).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JSONObject queryParam = new JSONObject();
        queryParam.put("projectGuid", (Object)appId);
        this.logger.info("\u83b7\u53d6AuthorToken\u53d1\u9001\u53c2\u6570{}", (Object)queryParam.toJSONString());
        JSONObject resData = this.sendPostRequestNoAuth(appKey, timestamp.toString(), sign, queryParam);
        this.logger.info("\u63a5\u6536AuthorToken\u7ed3\u679c\u4e3a{}", (Object)resData.toJSONString());
        String token = resData.getString("token");
        JSONObject authorToken = new JSONObject();
        authorToken.put("token", (Object)token);
        authorToken.put("projectGuid", (Object)appId);
        this.cacheManager.setex("YuFan::authorToken::" + appKey, (Serializable)authorToken, 86400);
        return authorToken;
    }

    public JSONObject sendPostRequestNoAuth(String appKey, String timestamp, String sign, JSONObject queryParam) {
        try {
            String queryUrl = baseUrl + "/v1/" + appId + "/auth?projectGuid=" + queryParam.getString("projectGuid");
            URL url = new URL(queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setRequestProperty("appKey", appKey);
            connection.setRequestProperty("timestamp", timestamp);
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                this.logger.info("\u8c03\u7528token\u67e5\u8be2\u7ed3\u679c\u4e3a{}", (Object)response.toString());
                return this.handelResJSON(JSONObject.parseObject((String)response.toString()), "authToken");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public JSONObject sendPostRequest(String queryUrl, JSONObject queryParam) {
        try {
            this.logger.info("\u67e5\u8be2\u4e1a\u52a1api\u4e3a" + queryUrl);
            this.logger.info("\u67e5\u8be2\u4e1a\u52a1\u53c2\u6570\u4e3a" + queryParam.toJSONString());
            URL url = new URL(baseUrl + queryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            JSONObject authorToken = this.getAuthorToken();
            connection.setRequestProperty("projectGuid", appId);
            connection.setRequestProperty("token", authorToken.get((Object)"token").toString());
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            if (queryParam != null) {
                outputStream.write(queryParam.toString().getBytes());
            }
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                this.logger.info("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c\u4e3a{}", (Object)response.toString());
                JSONObject baseResJSON = JSONObject.parseObject((String)response.toString());
                return this.handelResJSON(baseResJSON, queryUrl);
            }
            this.logger.info("\u670d\u52a1\u5668\u672a\u54cd\u5e94" + responseCode);
            throw new BusinessException(Integer.valueOf(responseCode));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject handelResJSON(JSONObject resJSON, String queryUrl) {
        this.logger.info("\u5904\u7406\u67e5\u8be2\u7ed3\u679c");
        if (resJSON == null) {
            throw new BusinessException("\u5b87\u6cdb\u5e73\u53f0\u7f51\u7edc\u5f02\u5e38\uff0c\u65e0\u6cd5\u5efa\u7acb\u8fde\u63a5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        String resCode = resJSON.getString("code");
        String resMsg = resJSON.getString("msg");
        if (!"WO_SUS1000".equals(resCode)) {
            throw new BusinessException("\u9519\u8bef\u4ee3\u7801\uff1a[" + resMsg + "]");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", resJSON.get((Object)"data"));
        return jsonObject;
    }
}

