package com.ejianc.business.openapi.cost.api;


import com.ejianc.business.openapi.cost.hystrix.SynchronizeDataHystrix;
import com.ejianc.business.openapi.cost.vo.GasAndElectricVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/24
 * @description:生产数据同步接口
 */
@FeignClient(name= "jcjt-cost-web", url="${common.env.feign-client-url}", path="jcjt-cost-web", fallback = SynchronizeDataHystrix.class)
public interface SynchronizeDataApi {
    /**
     * 同步生产数据
     * @param productDataVOS
     */
    @RequestMapping(value = "/api/cost/synchronizedataApi/synchronizedata", method = RequestMethod.POST)
    @ResponseBody
    void synchronizeData(@RequestBody List<ProductDataVO> productDataVOS);
    /**
     * @Description saveOrUpdate 同步燃气电量用量数据
     */
    @RequestMapping(value = "/api/cost/synchronizedataApi/synchronizegasdata", method = RequestMethod.POST)
    @ResponseBody
    void synchronizeGasData(@RequestBody GasAndElectricVO gasAndElectricVO);
}
