package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 材料盘点表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_production_material_inventory")
public class MaterialInventoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="material_id")
    private Long materialId; // 原材料id
    @TableField(value="material_name")
    private String materialName; // 原材料名称
    @TableField(value="category_id")
    private Long categoryId; // 原材料类别id
    @TableField(value="category_name")
    private String categoryName; // 原材料类别名称
    @TableField(value="material_varieties_id")
    private Long materialVarietiesId; // 原材料品种id
    @TableField(value="material_varieties_name")
    private String materialVarietiesName; // 原材料品种名称
    @TableField(value="position")
    private String position; // 库位
    @TableField(value="length")
    private BigDecimal length; // 长
    @TableField(value="width")
    private BigDecimal width; // 宽
    @TableField(value="height")
    private BigDecimal height; // 高
    @TableField(value="cubic")
    private BigDecimal cubic; // 立方
    @TableField(value="density")
    private BigDecimal density; // 密度
    @TableField(value="material_account")
    private BigDecimal materialAccount; // 盘点数量
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Long getMaterialVarietiesId() {
        return materialVarietiesId;
    }

    public void setMaterialVarietiesId(Long materialVarietiesId) {
        this.materialVarietiesId = materialVarietiesId;
    }
    public String getMaterialVarietiesName() {
        return materialVarietiesName;
    }

    public void setMaterialVarietiesName(String materialVarietiesName) {
        this.materialVarietiesName = materialVarietiesName;
    }
    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }
    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }
    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }
    public BigDecimal getCubic() {
        return cubic;
    }

    public void setCubic(BigDecimal cubic) {
        this.cubic = cubic;
    }
    public BigDecimal getDensity() {
        return density;
    }

    public void setDensity(BigDecimal density) {
        this.density = density;
    }
    public BigDecimal getMaterialAccount() {
        return materialAccount;
    }

    public void setMaterialAccount(BigDecimal materialAccount) {
        this.materialAccount = materialAccount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
