package com.ejianc.business.cost.controller.api;

import com.ejianc.business.cost.bean.DatasummaryEntity;
import com.ejianc.business.cost.bean.GasAndElectricEntity;
import com.ejianc.business.cost.mapper.DatasummaryMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IGasAndElectricService;
import com.ejianc.business.cost.service.IMaterialBuyService;
import com.ejianc.business.cost.service.IMaterialConsumeService;
import com.ejianc.business.cost.vo.DatasummaryVO;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.openapi.cost.vo.GasAndElectricVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/7/30
 * @description:同步生产数据插入mysql接口
 */
@RestController
@RequestMapping("/api/cost/synchronizedataApi")
public class SynchronizeDataApi {
    
    @Autowired
    private IDatasummaryService service;
    @Autowired
    private IGasAndElectricService gasAndElectricService;
    @Autowired
    private IMaterialConsumeService consumeService;
    @Autowired
    private IMaterialBuyService materialBuyService;

    /**
     * @Description saveOrUpdate 同步生产数据
     * 同步生产数据完生成原材料的本期消耗数量
     * 查询本期的原材料的分组汇总消耗数
     * 循环每个原材料对应找到原材料的购入数据计算原材料的本期消耗数据
     */
    @RequestMapping(value = "/synchronizedata", method = RequestMethod.POST)
    @ResponseBody
    public void synchronizeData(@RequestBody List<ProductDataVO> productDataVOS){
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        //同步生成生产数据
        List<DatasummaryEntity> datasummaryEntities = service.synchronizeData(productDataVOS);
        DatasummaryEntity entity = datasummaryEntities.get(0);
        String productTime = sf.format(entity.getProductTime());
        String orgId = entity.getOrgId().toString();
        //String productTime = datasummaryVO.getProductTime().toString();
        //对生成的生产数据按原材料分组汇总
        consumeService.generateMaterialConsume(productTime,orgId);
        //对每个原材料生成本期消耗数据
        //对每个原材料生成本期购入数据
        materialBuyService.generateMaterialBuy(productTime,orgId);
    }
    /**
     * @Description saveOrUpdate 同步燃气电量用量数据
     */
    @RequestMapping(value = "/synchronizegasdata", method = RequestMethod.POST)
    @ResponseBody
    public void synchronizeGasData(@RequestBody GasAndElectricVO gasAndElectricVO){
        GasAndElectricEntity entity = BeanMapper.map(gasAndElectricVO, GasAndElectricEntity.class);
        gasAndElectricService.save(entity);
    }
    ///**
    // * @Description saveOrUpdate 同步燃气电量用量数据
    // */
    //@RequestMapping(value = "/test", method = RequestMethod.GET)
    //@ResponseBody
    //public CommonResponse<List<MaterialUseTotalVO>> queryMaterialUseTotal(){
    //    List<MaterialUseTotalVO> materialUseTotalVOS = service.queryMaterialUseTotal();
    //    return CommonResponse.success("查询数据成功",materialUseTotalVOS);
    //}
}
