package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialInventoryEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialConsumeMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IMaterialConsumeService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.MaterialConsumeEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 本期消耗数量
 * 
 * @author generator
 * 
 */
@Service("materialConsumeService")
public class MaterialConsumeServiceImpl extends BaseServiceImpl<MaterialConsumeMapper, MaterialConsumeEntity> implements IMaterialConsumeService {

    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    private IDatasummaryService datasummaryService;

    @Qualifier("com.ejianc.business.purchasingmanagement.api.SelectApi")
    @Autowired
    private SelectApi api;

    @Autowired
    private IMaterialConsumeService materialConsumeService;

    /**
     * 生成原材料本期消耗数量
     * @param
     */
    @Override
    public void generateMaterialConsume(String productTime,String orgId) {
        List<MaterialConsumeEntity> materialConsumeEntities = new ArrayList<>();
        //查询原材料的指定时间内的原材料耗用量汇总
        List<MaterialUseTotalVO> materialUseTotalVOS = datasummaryService.queryMaterialUseTotal(productTime,orgId);
        if (!materialUseTotalVOS.isEmpty()){
            for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
                //查询每一个原材料的本期购入数据
                CommonResponse<AcceptanceVO> commonResponse = api.queryMaterialAcceptance(
                        materialUseTotalVO.getMaterialId().toString(),
                        materialUseTotalVO.getProductTime().toString(),
                        materialUseTotalVO.getOrgId().toString()
                );
                if (commonResponse.getCode() == 0){
                    //查询到原材料的本期购入数据
                    AcceptanceVO data = commonResponse.getData();
                    //查询原材料的最新期初库存数据
                    QueryWrapper<MaterialStartInventoryEntity> query = new QueryWrapper<>();
                    query.eq("material_id",materialUseTotalVO.getMaterialId())
                         .orderByDesc("create_time");
                    List<MaterialStartInventoryEntity> list = materialStartInventoryService.list(query);
                    /**
                     *
                     */
                    if (!list.isEmpty()){
                        //获取最近的一条期初库存数据
                        MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
                        //写入原材料本期消耗数据
                        MaterialConsumeEntity materialConsumeEntity =
                                BeanMapper.map(materialUseTotalVO, MaterialConsumeEntity.class);
                        materialConsumeEntity.setConsumeDate(materialUseTotalVO.getProductTime());
                        materialConsumeEntity.setAccount(materialUseTotalVO.getMaterialUseTotal());
                        BigDecimal accountSum = BigDecimal.ZERO;
                        BigDecimal amountSum = BigDecimal.ZERO;
                        if (data.getMaterialId() != null){
                            accountSum=materialStartInventoryEntity.getMaterialAccount()
                                        .add(data.getAcceptanceQuantity());
                            amountSum=materialStartInventoryEntity.getInventoryAmount()
                                        .add(data.getAmount());
                        }else {
                            accountSum=materialStartInventoryEntity.getMaterialAccount();
                            amountSum=materialStartInventoryEntity.getInventoryAmount();
                        }
                        //写入本期消耗数据单价 单价 = (期初库存金额+本期购入金额)/(期初库存数量+本期购入数量)
                        materialConsumeEntity.setPrice(
                                amountSum.divide(accountSum,2,BigDecimal.ROUND_HALF_UP)
                        );
                        materialConsumeEntity.setAmount(
                                materialConsumeEntity.getAccount().multiply(materialConsumeEntity.getPrice())
                        );
                        materialConsumeEntities.add(materialConsumeEntity);
                    }
                }
            }
        }
        materialConsumeService.saveBatch(materialConsumeEntities);
    }
}
