package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialInventorySummaryEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialInventorySummaryMapper;
import com.ejianc.business.cost.service.IMaterialInventorySummaryService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialInventorySummaryVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.business.cost.vo.TransFormVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;

import java.util.List;

/**
 * 盘点汇总表
 *
 * @author generator
 */
@Service("materialInventorySummaryService")
public class MaterialInventorySummaryServiceImpl extends BaseServiceImpl<MaterialInventorySummaryMapper, MaterialInventorySummaryEntity> implements IMaterialInventorySummaryService {
    @Autowired
    IMaterialStartInventoryService service;
    @Autowired
    IMaterialInventorySummaryService materialInventorySummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "materialInventory-sum";//此处需要根据实际修改

    @Override
    public MaterialInventorySummaryVO saveMaterialInventorySummaryEntity(MaterialInventoryVO materialInventoryVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("material_Id", materialInventoryVO.getMaterialId());
        queryWrapper.eq("org_id", materialInventoryVO.getOrgId());
        queryWrapper.orderByDesc("create_time");
        List<MaterialStartInventoryEntity> list = service.list(queryWrapper);
        MaterialInventorySummaryEntity materialInventorySummaryEntity = null;
        if (!list.isEmpty()) {
            MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
            //转换共同属性字段
            TransFormVO transFormVO = BeanMapper.map(materialStartInventoryEntity, TransFormVO.class);
            materialInventorySummaryEntity = BeanMapper.map(transFormVO, MaterialInventorySummaryEntity.class);
            //获取单价
            BigDecimal price = materialStartInventoryEntity.getInventoryUnitPrice();
            //盘点汇总 单价 = 期初库存单价
            materialInventorySummaryEntity.setPrice(price);
            // 盘点数量
            materialInventorySummaryEntity.setInventoryQuantity
                    (materialInventoryVO.getMaterialAccount());
            //盘点金额 = 盘点数量 * 盘点金额
            materialInventorySummaryEntity.setInventoryAccount
                    (price.multiply(materialInventoryVO.getMaterialAccount()));
            //当前账面数量
            materialInventorySummaryEntity.setCurrentQuantity
                    (materialStartInventoryEntity.getMaterialAccount());
            //当前金额
            materialInventorySummaryEntity.setCurrentAmount
                    (materialStartInventoryEntity.getInventoryAmount());
            //盈亏金额 = 盘点金额 - 当前账面金额
            materialInventorySummaryEntity.setProfitLossAmount
                    (materialInventorySummaryEntity.getInventoryAccount()
                        .subtract(materialInventorySummaryEntity.getCurrentAmount()));
            //盈亏数量 = 盘点数量 - 当前账面数量
            materialInventorySummaryEntity.setProfitLossQuantity
                    (materialInventorySummaryEntity.getInventoryQuantity()
                        .subtract(materialInventorySummaryEntity.getCurrentQuantity()));
            //单据编号
            MaterialInventorySummaryVO saveOrUpdateVO = BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
            if (materialInventorySummaryEntity.getId() == null || materialInventorySummaryEntity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    materialInventorySummaryEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                }
            }
            //保存
            materialInventorySummaryService.save(materialInventorySummaryEntity);
        }
        MaterialInventorySummaryVO materialInventorySummaryVO=BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
        return materialInventorySummaryVO;
    }
}
