package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 骨料4投放明细
 * 
 * @author generator
 * 
 */
public class Aggregate4DetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long mid; // 主表id主键
    private Long materialId; // 原材料id
    private String materialName; // 原材料名称
    private BigDecimal materialThrowPercent; // 原材料投放比例
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long materialVarietiesId; // 原材料核算品种名称
    private String materialVarietiesName; // 原材料核算品种名称

    public String getMaterialVarietiesName() {
        return materialVarietiesName;
    }

    public void setMaterialVarietiesName(String materialVarietiesName) {
        this.materialVarietiesName = materialVarietiesName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    @ReferSerialTransfer(referCode = "MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getMaterialThrowPercent() {
        return materialThrowPercent;
    }

    public void setMaterialThrowPercent(BigDecimal materialThrowPercent) {
        this.materialThrowPercent = materialThrowPercent;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "VarietiesaccountingRef")
    public Long getMaterialVarietiesId() {
        return materialVarietiesId;
    }
    @ReferDeserialTransfer
    public void setMaterialVarietiesId(Long materialVarietiesId) {
        this.materialVarietiesId = materialVarietiesId;
    }
    
}
