/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.common.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springside.modules.nosql.redis.JedisTemplate;

@Component
public class MessageSendHelper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${share-link.effective-time-limit}")
    private Long effectiveTimeLimit;
    @Autowired
    private CacheManager cacheManager;
    public static final String LINK_CHECK_KEY_PREFIX = "linkCheck::";
    @Autowired
    private ISmsMessageApi smsMessageApi;
    public static final String SMS_TEMPLATE_CODE = "SMS_195335075";

    public boolean sendMsg(String subject, String content) {
        if (StringUtils.isBlank((CharSequence)subject) || StringUtils.isBlank((CharSequence)content)) {
            this.logger.error("\u5411\u79df\u6237\u4e0b\u6240\u6709\u7528\u6237\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4e3b\u9898\u6216\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return false;
        }
        Object[] msgRecUserIds = new String[2];
        this.logger.info("\u5411\u7528\u6237{}\u53d1\u9001\u6d88\u606f\uff1asubject-{},content-{}: ", new Object[]{StringUtils.join((Object[])msgRecUserIds, (String)","), subject, content});
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse sendResp = this.pushMessageApi.sendUserMsg(msgParameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u5411\u79df\u6237\u4e0b\u6240\u6709\u7528\u6237\u53d1\u9001\u6d88\u606f: subject-{}, content-{} \u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)sendResp.getMsg());
            return false;
        }
        return true;
    }

    public String sendPhoneValidCode(String phone, String secret) {
        this.logger.info("\u624b\u673a\u53f7-{}\u5bf9\u8fde\u63a5secret-{}\u8fdb\u884c\u77ed\u4fe1\u9a8c\u8bc1\uff01", (Object)phone, (Object)secret);
        if (StringUtils.isBlank((CharSequence)phone)) {
            return "\u65e0\u6548\u7684\u624b\u673a\u53f7\u7801!";
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            return "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u7f3a\u5c11\u5206\u4eab\u94fe\u63a5\u6807\u8bc6!";
        }
        String key = LINK_CHECK_KEY_PREFIX + secret;
        JedisTemplate jedisTemplate = this.cacheManager.getJedisTemplate();
        String tl = jedisTemplate.get(key);
        if (null == tl) {
            return "\u8be5\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u5206\u4eab\u94fe\u63a5.";
        }
        Long curValidateTime = jedisTemplate.incr(key);
        if (curValidateTime >= this.effectiveTimeLimit) {
            return "\u5206\u4eab\u94fe\u63a5\u77ed\u4fe1\u9a8c\u8bc1\u8fbe\u5230\u6b21\u6570\u9650\u5236\uff0c\u8bf7\u83b7\u53d6\u65b0\u7684\u5206\u4eab\u94fe\u63a5.";
        }
        SmsMsgSendParam param = new SmsMsgSendParam();
        param.setPhone(phone);
        param.setTemplateCode(SMS_TEMPLATE_CODE);
        CommonResponse ts = this.smsMessageApi.sendMessage(param);
        this.logger.info("\u624b\u673a\u53f7-{}\u5bf9\u8fde\u63a5secret-{}\u8fdb\u884c\u77ed\u4fe1\u7ed3\u679c\uff0c {}", (Object)JSONObject.toJSONString((Object)ts));
        if (!ts.isSuccess()) {
            this.logger.info("\u624b\u673a\u53f7-{}\u5bf9\u8fde\u63a5secret-{}\u8fdb\u884c\u77ed\u4fe1\u9a8c\u8bc1\uff01", new Object[]{phone, secret, ts.getMsg()});
            return "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c" + ts.getMsg();
        }
        return null;
    }
}

