/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.business.supbusiness.enums.CheckSupplierSignStatusEnum;
import com.ejianc.business.supbusiness.service.ICheckService;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
@Api(value="\u6d88\u8017\u6750\u9a8c\u6536\u5355", tags={"\u6d88\u8017\u6750\u9a8c\u6536\u5355"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;
    @Autowired
    private ICheckService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CheckVO checkVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryAllList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u7b7e\u5b57\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplierSignStatus", new Parameter("eq", (Object)CheckSupplierSignStatusEnum.\u672a\u7b7e\u5b57.getCode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u7b7e\u5b57\u5217\u8868")
    @RequestMapping(value={"/querySignedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> querySignedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplierSignStatus", new Parameter("eq", (Object)CheckSupplierSignStatusEnum.\u5df2\u7b7e\u5b57.getCode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u534f\u540c\u5206\u4eab\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/detailBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> detailBySourceId(@RequestParam(value="id") String sourceId, @RequestParam(value="tl") String timeout, @RequestParam String weakFlag, @RequestParam String supplierTenant, @RequestParam String secret) {
        CheckVO checkvo = this.service.queryCheckBySourceId(sourceId);
        if (null == checkvo) {
            return CommonResponse.error((String)"\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        String checkMsg = this.billShareLInkCheckHelper.isShareLinkValid(timeout, sourceId, checkvo.getSupplierId().toString(), weakFlag, secret, supplierTenant);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            return CommonResponse.error((String)checkMsg);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)checkvo);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialCheck-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refMaterialCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u63a5\u6536\u9a8c\u6536\u5355")
    @RequestMapping(value={"/saveCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> saveCheck(HttpServletRequest request) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveCheck(request));
    }

    @ApiOperation(value="\u9a8c\u6536\u5355\u64a4\u56de")
    @RequestMapping(value={"/deleteCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> deleteCheck(@RequestBody CheckVO vo) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.deleteCheck(vo));
    }

    @ApiOperation(value="\u7b7e\u5b57")
    @RequestMapping(value={"/saveSupplierSign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveSupplierSign(@RequestBody CheckVO vo) {
        return CommonResponse.success((String)"\u63a5\u6536\u6210\u529f\uff01", (Object)this.service.saveSupplierSign(vo));
    }
}

